/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.lionarius.skinrestorer.SkinIO;
import net.lionarius.skinrestorer.SkinStorage;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2703;
import net.minecraft.class_2716;
import net.minecraft.class_2724;
import net.minecraft.class_2735;
import net.minecraft.class_2739;
import net.minecraft.class_2744;
import net.minecraft.class_2748;
import net.minecraft.class_2749;
import net.minecraft.class_2752;
import net.minecraft.class_2777;
import net.minecraft.class_2783;
import net.minecraft.class_3222;
import net.minecraft.class_7828;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinRestorer
implements DedicatedServerModInitializer {
    private static SkinStorage skinStorage;
    public static final Logger LOGGER;
    private static final Gson gson;

    public static SkinStorage getSkinStorage() {
        return skinStorage;
    }

    public void onInitializeServer() {
        skinStorage = new SkinStorage(new SkinIO(FabricLoader.getInstance().getConfigDir().resolve("skinrestorer")));
    }

    public static void refreshPlayer(class_3222 player) {
        ArrayList equipment = Lists.newArrayList();
        for (class_1304 slot : class_1304.values()) {
            class_1799 itemStack = player.method_6118(slot);
            if (itemStack.method_7960()) continue;
            equipment.add(Pair.of((Object)slot, (Object)itemStack.method_7972()));
        }
        for (class_3222 observer : player.field_13995.method_3760().method_14571()) {
            observer.field_13987.method_14364((class_2596)new class_7828(List.of(player.method_5667())));
            observer.field_13987.method_14364((class_2596)class_2703.method_43886(Collections.singleton(player)));
            if (observer == player) continue;
            observer.field_13987.method_14364((class_2596)new class_2716(new int[]{player.method_5628()}));
            observer.field_13987.method_14364((class_2596)new class_2604((class_1297)player));
            observer.field_13987.method_14364((class_2596)new class_2777((class_1297)player));
            observer.field_13987.method_14364((class_2596)new class_2739(player.method_5628(), player.method_5841().method_46357()));
            if (!equipment.isEmpty()) {
                observer.field_13987.method_14364((class_2596)new class_2744(player.method_5628(), (List)equipment));
            }
            if (!player.method_5765()) continue;
            observer.field_13987.method_14364((class_2596)new class_2752(player.method_5854()));
        }
        player.field_13987.method_14364((class_2596)new class_2724(player.method_52374(player.method_51469()), 2));
        player.field_13987.method_14363(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        player.field_13987.method_14364((class_2596)new class_2735(player.method_31548().field_7545));
        player.field_13987.method_14364((class_2596)new class_2739(player.method_5628(), player.method_5841().method_46357()));
        player.method_7355();
        player.field_7498.method_37420();
        player.field_13987.method_14364((class_2596)new class_2748(player.field_7510, player.field_7495, player.field_7520));
        player.field_13987.method_14364((class_2596)new class_2749(player.method_6032(), player.method_7344().method_7586(), player.method_7344().method_7589()));
        for (class_1293 instance : player.method_6026()) {
            player.field_13987.method_14364((class_2596)new class_2783(player.method_5628(), instance));
        }
        if (player.method_5765()) {
            player.field_13987.method_14364((class_2596)new class_2752(player.method_5854()));
        }
    }

    public static CompletableFuture<it.unimi.dsi.fastutil.Pair<Collection<class_3222>, Collection<GameProfile>>> setSkinAsync(MinecraftServer server, Collection<GameProfile> targets, Supplier<Property> skinSupplier) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            HashSet<GameProfile> acceptedProfiles = new HashSet<GameProfile>();
            Property skin = (Property)skinSupplier.get();
            if (Objects.isNull(skin)) {
                LOGGER.error("Cannot get the skin for {}", targets.stream().findFirst().orElseThrow());
                return it.unimi.dsi.fastutil.Pair.of(null, Collections.emptySet());
            }
            for (GameProfile profile : targets) {
                SkinRestorer.getSkinStorage().setSkin(profile.getId(), skin);
                acceptedProfiles.add(profile);
            }
            return it.unimi.dsi.fastutil.Pair.of((Object)skin, acceptedProfiles);
        }).thenApplyAsync(pair -> {
            Property skin = (Property)pair.left();
            if (Objects.isNull(skin)) {
                return it.unimi.dsi.fastutil.Pair.of(Collections.emptySet(), Collections.emptySet());
            }
            Collection acceptedProfiles = (Collection)pair.right();
            HashSet<class_3222> acceptedPlayers = new HashSet<class_3222>();
            JsonObject newSkinJson = (JsonObject)gson.fromJson(new String(Base64.getDecoder().decode(skin.value()), StandardCharsets.UTF_8), JsonObject.class);
            newSkinJson.remove("timestamp");
            for (GameProfile profile : acceptedProfiles) {
                class_3222 player = server.method_3760().method_14602(profile.getId());
                if (player == null || SkinRestorer.arePropertiesEquals(newSkinJson, player.method_7334())) continue;
                SkinRestorer.applyRestoredSkin(player.method_7334(), skin);
                SkinRestorer.refreshPlayer(player);
                acceptedPlayers.add(player);
            }
            return it.unimi.dsi.fastutil.Pair.of(acceptedPlayers, (Object)acceptedProfiles);
        }, (Executor)server)).orTimeout(10L, TimeUnit.SECONDS).exceptionally(e -> it.unimi.dsi.fastutil.Pair.of(Collections.emptySet(), Collections.emptySet()));
    }

    public static void applyRestoredSkin(GameProfile profile, Property skin) {
        profile.getProperties().removeAll((Object)"textures");
        profile.getProperties().put((Object)"textures", (Object)skin);
    }

    private static boolean arePropertiesEquals(@NotNull JsonObject x, @NotNull GameProfile y) {
        Property py = y.getProperties().get((Object)"textures").stream().findFirst().orElse(null);
        if (py == null) {
            return false;
        }
        try {
            JsonObject jy = (JsonObject)gson.fromJson(new String(Base64.getDecoder().decode(py.value()), StandardCharsets.UTF_8), JsonObject.class);
            jy.remove("timestamp");
            return x.equals((Object)jy);
        }
        catch (Exception ex) {
            LOGGER.info("Can not compare skin", (Throwable)ex);
            return false;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"SkinRestorer");
        gson = new Gson();
    }
}

