/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.lib;

import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.gui.screen.BrewerScreen;
import juuxel.adorn.client.gui.screen.GuideBookScreen;
import juuxel.adorn.client.resources.BookManagerFabric;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.menu.TradingStationMenu;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0004J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0004J%\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0015\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001c\u0010\u001aR\u0017\u0010\u001d\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001e\u0010\u001a\u00a8\u0006 "}, d2={"Ljuuxel/adorn/lib/AdornNetworking;", "", "", "init", "()V", "initClient", "Lnet/minecraft/class_1657;", "player", "", "syncId", "Ljuuxel/adorn/fluid/FluidReference;", "fluid", "sendBrewerFluidSync", "(Lnet/minecraft/class_1657;ILjuuxel/adorn/fluid/FluidReference;)V", "Lnet/minecraft/class_2960;", "bookId", "sendOpenBookPacket", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_2960;)V", "slotId", "Lnet/minecraft/class_1799;", "stack", "sendSetTradeStack", "(IILnet/minecraft/class_1799;)V", "BREWER_FLUID_SYNC", "Lnet/minecraft/class_2960;", "getBREWER_FLUID_SYNC", "()Lnet/minecraft/class_2960;", "OPEN_BOOK", "getOPEN_BOOK", "SET_TRADE_STACK", "getSET_TRADE_STACK", "<init>", "Adorn"})
public final class AdornNetworking {
    @NotNull
    public static final AdornNetworking INSTANCE = new AdornNetworking();
    @NotNull
    private static final class_2960 OPEN_BOOK = AdornCommon.id("open_book");
    @NotNull
    private static final class_2960 BREWER_FLUID_SYNC = AdornCommon.id("brewer_fluid_sync");
    @NotNull
    private static final class_2960 SET_TRADE_STACK = AdornCommon.id("set_trade_stack");

    private AdornNetworking() {
    }

    @NotNull
    public final class_2960 getOPEN_BOOK() {
        return OPEN_BOOK;
    }

    @NotNull
    public final class_2960 getBREWER_FLUID_SYNC() {
        return BREWER_FLUID_SYNC;
    }

    @NotNull
    public final class_2960 getSET_TRADE_STACK() {
        return SET_TRADE_STACK;
    }

    public final void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SET_TRADE_STACK, AdornNetworking::init$lambda$1);
    }

    @Environment(value=EnvType.CLIENT)
    public final void initClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)OPEN_BOOK, AdornNetworking::initClient$lambda$3);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)BREWER_FLUID_SYNC, AdornNetworking::initClient$lambda$5);
    }

    public final void sendOpenBookPacket(@NotNull class_1657 player, @NotNull class_2960 bookId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        if (player instanceof class_3222) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10812(bookId);
            ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)OPEN_BOOK, (class_2540)buf);
        }
    }

    public final void sendBrewerFluidSync(@NotNull class_1657 player, int syncId, @NotNull FluidReference fluid) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        if (player instanceof class_3222) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_52997(syncId);
            Intrinsics.checkNotNull((Object)buf);
            fluid.write(buf);
            ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)BREWER_FLUID_SYNC, (class_2540)buf);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public final void sendSetTradeStack(int syncId, int slotId, @NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(syncId);
        buf.method_10804(slotId);
        buf.method_10793(stack);
        ClientPlayNetworking.send((class_2960)SET_TRADE_STACK, (class_2540)buf);
    }

    private static final void init$lambda$1$lambda$0(class_3222 $player, int $syncId, int $slotId, class_1799 $stack) {
        class_1703 menu = $player.field_7512;
        if (menu.field_7763 == $syncId && menu instanceof TradingStationMenu) {
            TradingStationMenu tradingStationMenu = (TradingStationMenu)menu;
            Intrinsics.checkNotNull((Object)$stack);
            Intrinsics.checkNotNull((Object)$player);
            tradingStationMenu.updateTradeStack($slotId, $stack, (class_1657)$player);
        }
    }

    private static final void init$lambda$1(MinecraftServer server, class_3222 player, class_3244 class_32442, class_2540 buf, PacketSender packetSender) {
        int syncId = buf.method_10816();
        int slotId = buf.method_10816();
        class_1799 stack = buf.method_10819();
        server.execute(() -> AdornNetworking.init$lambda$1$lambda$0(player, syncId, slotId, stack));
    }

    private static final void initClient$lambda$3$lambda$2(class_310 $client, class_2960 $bookId) {
        Intrinsics.checkNotNull((Object)$bookId);
        $client.method_1507((class_437)new GuideBookScreen(BookManagerFabric.INSTANCE.get($bookId)));
    }

    private static final void initClient$lambda$3(class_310 client, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        class_2960 bookId = buf.method_10810();
        client.execute(() -> AdornNetworking.initClient$lambda$3$lambda$2(client, bookId));
    }

    private static final void initClient$lambda$5$lambda$4(class_310 $client, int $syncId, FluidVolume $volume) {
        Intrinsics.checkNotNullParameter((Object)$volume, (String)"$volume");
        Intrinsics.checkNotNull((Object)$client);
        BrewerScreen.Companion.setFluidFromPacket($client, $syncId, $volume);
    }

    private static final void initClient$lambda$5(class_310 client, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        short syncId = buf.readUnsignedByte();
        Intrinsics.checkNotNull((Object)buf);
        FluidVolume volume = FluidVolume.Companion.load(buf);
        client.execute(() -> AdornNetworking.initClient$lambda$5$lambda$4(client, syncId, volume));
    }
}

