/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.item;

import java.util.Collection;
import java.util.List;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.fluid.StepMaximum;
import juuxel.adorn.item.ItemWithDescription;
import juuxel.adorn.lib.AdornSounds;
import juuxel.adorn.platform.FluidBridge;
import juuxel.adorn.util.ColorsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010&\u001a\u00020%\u00a2\u0006\u0004\b'\u0010(J7\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ/\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010#\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b#\u0010$\u00a8\u0006*"}, d2={"Ljuuxel/adorn/item/WateringCanItem;", "Ljuuxel/adorn/item/ItemWithDescription;", "Lnet/minecraft/class_1799;", "stack", "Lnet/minecraft/class_1937;", "world", "", "Lnet/minecraft/class_2561;", "texts", "Lnet/minecraft/class_1836;", "context", "", "appendTooltip", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1937;Ljava/util/List;Lnet/minecraft/class_1836;)V", "", "getItemBarColor", "(Lnet/minecraft/class_1799;)I", "getItemBarStep", "", "isItemBarVisible", "(Lnet/minecraft/class_1799;)Z", "Lnet/minecraft/class_1657;", "user", "Lnet/minecraft/class_1268;", "hand", "Lnet/minecraft/class_1271;", "use", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1657;Lnet/minecraft/class_1268;)Lnet/minecraft/class_1271;", "Lnet/minecraft/class_2338;", "pos", "player", "water", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_1657;Lnet/minecraft/class_1799;)V", "Lnet/minecraft/class_2680;", "state", "waterFarmlandBlock", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;)V", "Lnet/minecraft/class_1792$class_1793;", "settings", "<init>", "(Lnet/minecraft/class_1792$class_1793;)V", "Companion", "Adorn"})
public final class WateringCanItem
extends ItemWithDescription {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NBT_WATER_LEVEL = "WaterLevel";
    @NotNull
    public static final String NBT_FERTILIZER_LEVEL = "FertilizerLevel";
    private static final int ITEM_BAR_STEPS = 13;
    private static final int MAX_WATER_LEVEL = 50;
    public static final int MAX_FERTILIZER_LEVEL = 32;
    private static final float WATER_LEVEL_DIVISOR = 0.02f;
    private static final int WATER_LEVELS_PER_BUCKET = 10;
    @NotNull
    private static final StepMaximum FLUID_DRAIN_PREDICATE = new StepMaximum(0L, 1000L, 100L, FluidUnit.LITRE);

    public WateringCanItem(@NotNull class_1792.class_1793 settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 world, @NotNull class_1657 user, @NotNull class_1268 hand) {
        class_1271 class_12712;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        class_1799 stack = user.method_5998(hand);
        boolean success = false;
        class_3965 hitResult = class_1792.method_7872((class_1937)world, (class_1657)user, (class_3959.class_242)class_3959.class_242.field_1345);
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            class_1271 class_12713 = class_1271.method_22430((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)class_12713, (String)"pass(...)");
            return class_12713;
        }
        class_2487 nbt = stack.method_7948();
        int waterLevel = nbt.method_10550(NBT_WATER_LEVEL);
        class_2338 pos = hitResult.method_17777();
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (waterLevel < 50) {
            if (block instanceof class_2263 && world.method_8316(pos).method_39360((class_3611)class_3612.field_15910)) {
                drained = ((class_2263)block).method_9700(user, (class_1936)world, pos, state);
                ((class_2263)block).method_32351().ifPresent(arg_0 -> WateringCanItem.use$lambda$1(arg_0 -> WateringCanItem.use$lambda$0(user, arg_0), arg_0));
                if (drained.method_31574(class_1802.field_8705)) {
                    waterLevel = Math.min(waterLevel + 10, 50);
                    nbt.method_10569(NBT_WATER_LEVEL, waterLevel);
                    success = true;
                }
            } else {
                FluidBridge fluidBridge = FluidBridge.Companion.get();
                Intrinsics.checkNotNull((Object)pos);
                class_2350 class_23502 = hitResult.method_17780().method_10153();
                Intrinsics.checkNotNullExpressionValue((Object)class_23502, (String)"getOpposite(...)");
                class_3609 class_36092 = class_3612.field_15910;
                Intrinsics.checkNotNullExpressionValue((Object)class_36092, (String)"WATER");
                drained = fluidBridge.drain(world, pos, null, class_23502, (class_3611)class_36092, FLUID_DRAIN_PREDICATE);
                if (drained != null) {
                    long amount = FluidUnit.Companion.convert(((FluidVolume)drained).getAmount(), ((FluidVolume)drained).getUnit(), FluidUnit.LITRE);
                    int levels = (int)(amount / FLUID_DRAIN_PREDICATE.getStep());
                    waterLevel = Math.min(waterLevel + levels, 50);
                    nbt.method_10569(NBT_WATER_LEVEL, waterLevel);
                    success = true;
                    user.method_5783(class_3417.field_15126, 1.0f, 1.0f);
                }
            }
        }
        if (!success && waterLevel > 0) {
            success = true;
            nbt.method_10569(NBT_WATER_LEVEL, --waterLevel);
            world.method_33596((class_1297)user, class_5712.field_28146, pos);
            world.method_45447(user, pos, AdornSounds.INSTANCE.getITEM_WATERING_CAN_WATER(), class_3419.field_15248);
            user.method_7357().method_7906((class_1792)this, 10);
            class_2338.class_2339 mut = new class_2338.class_2339();
            for (int xo = -1; xo < 2; ++xo) {
                for (int zo = -1; zo < 2; ++zo) {
                    mut.method_10103(pos.method_10263() + xo, pos.method_10264(), pos.method_10260() + zo);
                    class_2338 class_23382 = (class_2338)mut;
                    Intrinsics.checkNotNull((Object)stack);
                    this.water(world, class_23382, user, stack);
                    if (!(world instanceof class_3218)) continue;
                    WateringCanItem.Companion.spawnParticlesAt((class_3218)world, (class_2338)mut, hitResult.method_17784().field_1351);
                }
            }
        }
        if (success) {
            var12_12 = class_1271.method_29237((Object)stack, (boolean)world.method_8608());
            Intrinsics.checkNotNull((Object)var12_12);
            class_12712 = var12_12;
        } else {
            var12_12 = class_1271.method_22430((Object)stack);
            Intrinsics.checkNotNull((Object)var12_12);
            class_12712 = var12_12;
        }
        return class_12712;
    }

    private final void water(class_1937 world, class_2338 pos, class_1657 player, class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        int fertilizerLevel = nbt.method_10550(NBT_FERTILIZER_LEVEL);
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (fertilizerLevel > 0 && world.field_9229.method_43048(9) == 0) {
            if (block instanceof class_2256 && ((class_2256)block).method_9651((class_4538)world, pos, state)) {
                if (world instanceof class_3218 && ((class_2256)block).method_9650(world, world.field_9229, pos, state)) {
                    ((class_2256)block).method_9652((class_3218)world, world.field_9229, pos, state);
                }
                world.method_8444(player, 1505, pos, 5);
            }
            nbt.method_10569(NBT_FERTILIZER_LEVEL, fertilizerLevel - 1);
        }
        if (!world.field_9236) {
            class_2338 downPos;
            class_2680 downState;
            if (block instanceof class_2344) {
                Intrinsics.checkNotNull((Object)state);
                this.waterFarmlandBlock(world, pos, state);
            } else if (!state.method_26234((class_1922)world, pos) && (downState = world.method_8320(downPos = pos.method_10074())).method_26204() instanceof class_2344) {
                Intrinsics.checkNotNull((Object)downPos);
                Intrinsics.checkNotNull((Object)downState);
                this.waterFarmlandBlock(world, downPos, downState);
            }
        }
    }

    private final void waterFarmlandBlock(class_1937 world, class_2338 pos, class_2680 state) {
        Integer moisture = (Integer)state.method_11654((class_2769)class_2344.field_11009);
        Intrinsics.checkNotNull((Object)moisture);
        if (moisture < 7) {
            int moistureChange = world.field_9229.method_39332(2, 6);
            int newMoisture = Math.min(moisture + moistureChange, 7);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2344.field_11009, (Comparable)Integer.valueOf(newMoisture)), 2);
        }
    }

    public boolean method_31567(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return true;
    }

    public int method_31569(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.method_7985()) {
            class_2487 class_24872 = stack.method_7969();
            Intrinsics.checkNotNull((Object)class_24872);
            class_2487 nbt = class_24872;
            if (nbt.method_10573(NBT_WATER_LEVEL, 3)) {
                int waterLevel = class_3532.method_15340((int)nbt.method_10550(NBT_WATER_LEVEL), (int)0, (int)50);
                return class_3532.method_48781((float)(0.02f * (float)waterLevel), (int)0, (int)13);
            }
        }
        return 0;
    }

    public int method_31571(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        class_2487 nbt = stack.method_7948();
        float rg = class_3532.method_37958((float)nbt.method_10550(NBT_FERTILIZER_LEVEL), (float)0.0f, (float)32.0f, (float)0.4f, (float)1.0f);
        return ColorsKt.color$default(rg, rg, 1.0f, 0.0f, 8, null);
    }

    @Override
    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 world, @NotNull List<class_2561> texts, @NotNull class_1836 context2) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(texts, (String)"texts");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = stack.method_7969();
        if (object == null || (object = Integer.valueOf(object.method_10550(NBT_FERTILIZER_LEVEL)).toString()) == null) {
            object = "0";
        }
        class_5250 currentLevel = class_2561.method_43470((String)object).method_27692(class_124.field_1062);
        class_5250 maxLevel = class_2561.method_43470((String)"32").method_27692(class_124.field_1062);
        Collection collection = texts;
        Object[] objectArray = new Object[]{currentLevel, maxLevel};
        collection.add(class_2561.method_43469((String)"item.adorn.watering_can.fertilizer", (Object[])objectArray).method_27692(class_124.field_1080));
        super.method_7851(stack, world, texts, context2);
    }

    private static final Unit use$lambda$0(class_1657 $user, class_3414 it) {
        Intrinsics.checkNotNullParameter((Object)$user, (String)"$user");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $user.method_5783(it, 1.0f, 1.0f);
        return Unit.INSTANCE;
    }

    private static final void use$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ'\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Ljuuxel/adorn/item/WateringCanItem$Companion;", "", "Lnet/minecraft/class_3218;", "world", "Lnet/minecraft/class_2338;", "pos", "", "y", "", "spawnParticlesAt", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;D)V", "Ljuuxel/adorn/fluid/StepMaximum;", "FLUID_DRAIN_PREDICATE", "Ljuuxel/adorn/fluid/StepMaximum;", "", "ITEM_BAR_STEPS", "I", "MAX_FERTILIZER_LEVEL", "MAX_WATER_LEVEL", "", "NBT_FERTILIZER_LEVEL", "Ljava/lang/String;", "NBT_WATER_LEVEL", "WATER_LEVELS_PER_BUCKET", "", "WATER_LEVEL_DIVISOR", "F", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        private final void spawnParticlesAt(class_3218 world, class_2338 pos, double y) {
            double px = (double)pos.method_10263() + 0.3 + world.field_9229.method_43058() * 0.4;
            double py = y + 0.1;
            double pz = (double)pos.method_10260() + 0.3 + world.field_9229.method_43058() * 0.4;
            double vx = world.field_9229.method_43058() * 0.2 - 0.1;
            double vy = 0.1;
            double vz = world.field_9229.method_43058() * 0.2 - 0.1;
            world.method_14199((class_2394)class_2398.field_11202, px, py, pz, 4, vx, vy, vz, 0.5);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

