/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import juuxel.adorn.fluid.FluidAmountPredicate;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.HasFluidAmount;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\r\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\u000f\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\u00020\u00148\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Ljuuxel/adorn/fluid/StepMaximum;", "Ljuuxel/adorn/fluid/FluidAmountPredicate;", "", "amount", "Ljuuxel/adorn/fluid/FluidUnit;", "unit", "", "test", "(JLjuuxel/adorn/fluid/FluidUnit;)Z", "max", "J", "getMax", "()J", "min", "getMin", "step", "getStep", "Ljuuxel/adorn/fluid/FluidUnit;", "getUnit", "()Ljuuxel/adorn/fluid/FluidUnit;", "Ljuuxel/adorn/fluid/HasFluidAmount;", "upperBound", "Ljuuxel/adorn/fluid/HasFluidAmount;", "getUpperBound", "()Ljuuxel/adorn/fluid/HasFluidAmount;", "<init>", "(JJJLjuuxel/adorn/fluid/FluidUnit;)V", "Adorn"})
@SourceDebugExtension(value={"SMAP\nStepMaximum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StepMaximum.kt\njuuxel/adorn/fluid/StepMaximum\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,30:1\n1#2:31\n*E\n"})
public final class StepMaximum
implements FluidAmountPredicate {
    private final long min;
    private final long max;
    private final long step;
    @NotNull
    private final FluidUnit unit;
    @NotNull
    private final HasFluidAmount upperBound;

    public StepMaximum(long min, long max, long step, @NotNull FluidUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.min = min;
        this.max = max;
        this.step = step;
        this.unit = unit;
        this.upperBound = new HasFluidAmount(this){
            private final long amount;
            @NotNull
            private final FluidUnit unit;
            {
                this.amount = $receiver.getMax();
                this.unit = $receiver.getUnit();
            }

            public long getAmount() {
                return this.amount;
            }

            @NotNull
            public FluidUnit getUnit() {
                return this.unit;
            }
        };
        if (!(this.min < this.max)) {
            boolean $i$a$-require-StepMaximum$32 = false;
            String $i$a$-require-StepMaximum$32 = "min must be less than max";
            throw new IllegalArgumentException($i$a$-require-StepMaximum$32.toString());
        }
        if (!((this.max - this.min) % this.step == 0L)) {
            boolean bl = false;
            String string = "max - min must be divisible by step";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final long getMin() {
        return this.min;
    }

    public final long getMax() {
        return this.max;
    }

    public final long getStep() {
        return this.step;
    }

    @NotNull
    public final FluidUnit getUnit() {
        return this.unit;
    }

    @Override
    @NotNull
    public HasFluidAmount getUpperBound() {
        return this.upperBound;
    }

    @Override
    public boolean test(long amount, @NotNull FluidUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        long toCompare = FluidUnit.Companion.convert(amount, unit, this.unit);
        if (toCompare < this.min || toCompare > this.max) {
            return false;
        }
        long zeroed = toCompare - this.min;
        return zeroed % this.step == 0L;
    }
}

