/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.renderer;

import juuxel.adorn.block.AbstractKitchenCounterBlock;
import juuxel.adorn.block.entity.KitchenSinkBlockEntity;
import juuxel.adorn.client.FluidRenderingBridge;
import juuxel.adorn.util.LoggingKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000  *\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003:\u0001 B\u000f\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\u000f\u0010\u0010J?\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Ljuuxel/adorn/client/renderer/KitchenSinkRenderer;", "Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;", "T", "Lnet/minecraft/class_827;", "entity", "", "getFluidColor", "(Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;)I", "", "getFluidLevel", "(Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;)D", "Lnet/minecraft/class_1058;", "getFluidSprite", "(Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;)Lnet/minecraft/class_1058;", "", "isEmpty", "(Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;)Z", "", "tickDelta", "Lnet/minecraft/class_4587;", "matrices", "Lnet/minecraft/class_4597;", "vertexConsumers", "light", "overlay", "", "render", "(Ljuuxel/adorn/block/entity/KitchenSinkBlockEntity;FLnet/minecraft/class_4587;Lnet/minecraft/class_4597;II)V", "Lnet/minecraft/class_5614$class_5615;", "context", "<init>", "(Lnet/minecraft/class_5614$class_5615;)V", "Companion", "Adorn"})
@Environment(value=EnvType.CLIENT)
public abstract class KitchenSinkRenderer<T extends KitchenSinkBlockEntity>
implements class_827<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER = LoggingKt.logger();
    private static final float PX = 0.0625f;
    private static final float X_START = 0.125f;
    private static final float X_END = 0.8125f;
    private static final float Z_START = 0.125f;
    private static final float Z_END = 0.875f;
    private static final float Y_START = 0.4375f;
    private static final float Y_END = 0.9375f;
    private static final double LITRES_PER_BLOCK = 1000.0;
    private static final float WAVE_PERIOD = 12000.0f;
    private static final float WAVE_HEIGHT = 0.0625f;
    private static final float MS_PER_TICK = 50.0f;

    public KitchenSinkRenderer(@NotNull class_5614.class_5615 context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
    }

    public void render(@NotNull T entity, float tickDelta, @NotNull class_4587 matrices, @NotNull class_4597 vertexConsumers, int light, int overlay) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        if (this.isEmpty(entity)) {
            return;
        }
        class_1058 sprite = this.getFluidSprite(entity);
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)sprite.method_45852()));
        float u0 = class_3532.method_16439((float)0.125f, (float)sprite.method_4594(), (float)sprite.method_4577());
        float u1 = class_3532.method_16439((float)0.875f, (float)sprite.method_4594(), (float)sprite.method_4577());
        float v0 = class_3532.method_16439((float)0.125f, (float)sprite.method_4593(), (float)sprite.method_4575());
        float v1 = class_3532.method_16439((float)0.8125f, (float)sprite.method_4593(), (float)sprite.method_4575());
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        Comparable comparable = entity.method_11010().method_11654((class_2769)AbstractKitchenCounterBlock.Companion.getFACING());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"get(...)");
        matrices.method_22907(class_7833.field_40716.rotationDegrees(KitchenSinkRenderer.Companion.getRotation((class_2350)comparable)));
        matrices.method_22904(-0.5, 0.0, -0.5);
        double fluidLevel = this.getFluidLevel(entity) / 1000.0;
        matrices.method_22904(0.0, class_3532.method_16436((double)fluidLevel, (double)0.4375, (double)0.9375), 0.0);
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        Matrix3f normalMatrix = matrices.method_23760().method_23762();
        int color = this.getFluidColor(entity);
        buffer.method_22918(positionMatrix, 0.125f, KitchenSinkRenderer.render$y(0.125f, 0.875f), 0.875f).method_39415(color).method_22913(u0, v0).method_22922(overlay).method_22916(light).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(positionMatrix, 0.8125f, KitchenSinkRenderer.render$y(0.8125f, 0.875f), 0.875f).method_39415(color).method_22913(u0, v1).method_22922(overlay).method_22916(light).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(positionMatrix, 0.8125f, KitchenSinkRenderer.render$y(0.8125f, 0.125f), 0.125f).method_39415(color).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
        buffer.method_22918(positionMatrix, 0.125f, KitchenSinkRenderer.render$y(0.125f, 0.125f), 0.125f).method_39415(color).method_22913(u1, v0).method_22922(overlay).method_22916(light).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
        matrices.method_22909();
    }

    private final class_1058 getFluidSprite(T entity) {
        class_1058 sprite = FluidRenderingBridge.Companion.get().getStillSprite(((KitchenSinkBlockEntity)((Object)entity)).getFluidReference());
        if (sprite == null) {
            LOGGER.error("Could not find sprite for fluid reference {} when rendering kitchen sink at {}", (Object)((KitchenSinkBlockEntity)((Object)entity)).getFluidReference(), (Object)entity.method_11016());
            Object r = class_310.method_1551().method_1549(class_1059.field_5275).apply(class_1047.method_4539());
            Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
            return (class_1058)r;
        }
        return sprite;
    }

    private final int getFluidColor(T entity) {
        return FluidRenderingBridge.Companion.get().getColor(((KitchenSinkBlockEntity)((Object)entity)).getFluidReference(), (class_1920)entity.method_10997(), entity.method_11016());
    }

    protected abstract double getFluidLevel(@NotNull T var1);

    protected abstract boolean isEmpty(@NotNull T var1);

    private static final float render$y(float x, float z) {
        class_746 class_7462 = class_310.method_1551().field_1724;
        Intrinsics.checkNotNull((Object)class_7462);
        float time = (float)class_7462.field_6012 * 50.0f % 12000.0f;
        float t = time * ((float)Math.PI * 2) / 12000.0f;
        return class_3532.method_15374((float)(t + x + z)) * 0.0625f / (float)2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0014\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u000eR\u0014\u0010\u0016\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ljuuxel/adorn/client/renderer/KitchenSinkRenderer$Companion;", "", "Lnet/minecraft/class_2350;", "facing", "", "getRotation", "(Lnet/minecraft/class_2350;)F", "", "LITRES_PER_BLOCK", "D", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "MS_PER_TICK", "F", "PX", "WAVE_HEIGHT", "WAVE_PERIOD", "X_END", "X_START", "Y_END", "Y_START", "Z_END", "Z_START", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        private final float getRotation(class_2350 facing) {
            return switch (WhenMappings.$EnumSwitchMapping$0[facing.ordinal()]) {
                case 1 -> 0.0f;
                case 2 -> 90.0f;
                case 3 -> 180.0f;
                case 4 -> 270.0f;
                default -> 0.0f;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[class_2350.values().length];
                try {
                    nArray[class_2350.field_11034.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[class_2350.field_11043.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[class_2350.field_11039.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[class_2350.field_11035.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

