/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.FluidRenderingBridge;
import juuxel.adorn.client.gui.screen.AdornMenuScreen;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.menu.BrewerMenu;
import juuxel.adorn.util.ColorsKt;
import juuxel.adorn.util.LoggingKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.class_1058;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0017\u001a\u00020\u0002\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u001a\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ/\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Ljuuxel/adorn/client/gui/screen/BrewerScreen;", "Ljuuxel/adorn/client/gui/screen/AdornMenuScreen;", "Ljuuxel/adorn/menu/BrewerMenu;", "Lnet/minecraft/class_332;", "context", "", "delta", "", "mouseX", "mouseY", "", "drawBackground", "(Lnet/minecraft/class_332;FII)V", "x", "y", "drawMouseoverTooltip", "(Lnet/minecraft/class_332;II)V", "Ljuuxel/adorn/fluid/FluidReference;", "fluid", "", "Lnet/minecraft/class_2561;", "getFluidTooltip", "(Ljuuxel/adorn/fluid/FluidReference;)Ljava/util/List;", "menu", "Lnet/minecraft/class_1661;", "playerInventory", "title", "<init>", "(Ljuuxel/adorn/menu/BrewerMenu;Lnet/minecraft/class_1661;Lnet/minecraft/class_2561;)V", "Companion", "Adorn"})
public final class BrewerScreen
extends AdornMenuScreen<BrewerMenu> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER = LoggingKt.logger();
    @NotNull
    private static final class_2960 TEXTURE = AdornCommon.id("textures/gui/brewer.png");
    public static final int FLUID_AREA_HEIGHT = 59;

    public BrewerScreen(@NotNull BrewerMenu menu, @NotNull class_1661 playerInventory, @NotNull class_2561 title) {
        Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super((class_1703)menu, playerInventory, title);
    }

    protected void method_2389(@NotNull class_332 context2, float delta, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        context2.method_25302(TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        Companion.drawFluid(context2, this.field_2776 + 145, this.field_2800 + 17, ((BrewerMenu)this.field_2797).getFluid());
        context2.method_25302(TEXTURE, this.field_2776 + 145, this.field_2800 + 21, 176, 25, 16, 51);
        int progress = ((BrewerMenu)this.field_2797).getProgress();
        if (progress > 0) {
            float progressFract = (float)progress / 200.0f;
            context2.method_25302(TEXTURE, this.field_2776 + 84, this.field_2800 + 24, 176, 0, 8, class_3532.method_15386((float)(progressFract * (float)25)));
        }
    }

    protected void method_2380(@NotNull class_332 context2, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super.method_2380(context2, x, y);
        int x2 = x - this.field_2776;
        int y2 = y - this.field_2800;
        boolean bl = 145 <= x2 ? x2 < 161 : false;
        if (bl) {
            boolean bl2 = 17 <= y2 ? y2 < 76 : false;
            if (bl2) {
                context2.method_51434(this.field_22793, this.getFluidTooltip(((BrewerMenu)this.field_2797).getFluid()), x, y);
            }
        }
    }

    private final List<class_2561> getFluidTooltip(FluidReference fluid) {
        FluidRenderingBridge fluidRenderingBridge = FluidRenderingBridge.Companion.get();
        class_310 class_3102 = this.field_22787;
        Intrinsics.checkNotNull((Object)class_3102);
        class_1836.class_1837 class_18372 = class_3102.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070;
        Intrinsics.checkNotNull((Object)class_18372);
        return fluidRenderingBridge.getTooltip(fluid, (class_1836)class_18372, 2000);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b(\u0010)J-\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJg\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J%\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006*"}, d2={"Ljuuxel/adorn/client/gui/screen/BrewerScreen$Companion;", "", "Lnet/minecraft/class_332;", "context", "", "x", "y", "Ljuuxel/adorn/fluid/FluidReference;", "fluid", "", "drawFluid", "(Lnet/minecraft/class_332;IILjuuxel/adorn/fluid/FluidReference;)V", "", "width", "height", "u0", "v0", "u1", "v1", "Lnet/minecraft/class_1058;", "sprite", "color", "drawSprite", "(Lnet/minecraft/class_332;IFFFFFFFLnet/minecraft/class_1058;I)V", "Lnet/minecraft/class_310;", "client", "syncId", "Ljuuxel/adorn/fluid/FluidVolume;", "setFluidFromPacket", "(Lnet/minecraft/class_310;ILjuuxel/adorn/fluid/FluidVolume;)V", "FLUID_AREA_HEIGHT", "I", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "Lnet/minecraft/class_2960;", "TEXTURE", "Lnet/minecraft/class_2960;", "getTEXTURE", "()Lnet/minecraft/class_2960;", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getTEXTURE() {
            return TEXTURE;
        }

        public final void setFluidFromPacket(@NotNull class_310 client, int syncId, @NotNull FluidVolume fluid) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
            class_437 screen = client.field_1755;
            if (screen instanceof class_3936) {
                class_1703 menu = ((class_3936)screen).method_17577();
                if (menu.field_7763 == syncId && menu instanceof BrewerMenu) {
                    ((BrewerMenu)menu).setFluid(fluid);
                }
            }
        }

        private final void drawSprite(class_332 context2, int x, float y, float width, float height, float u0, float v0, float u1, float v1, class_1058 sprite, int color) {
            RenderSystem.enableBlend();
            RenderSystem.setShader(class_757::method_34541);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_45852());
            class_287 buffer = class_289.method_1348().method_1349();
            Matrix4f positionMatrix = context2.method_51448().method_23760().method_23761();
            float au0 = class_3532.method_16439((float)u0, (float)sprite.method_4594(), (float)sprite.method_4577());
            float au1 = class_3532.method_16439((float)u1, (float)sprite.method_4594(), (float)sprite.method_4577());
            float av0 = class_3532.method_16439((float)v0, (float)sprite.method_4593(), (float)sprite.method_4575());
            float av1 = class_3532.method_16439((float)v1, (float)sprite.method_4593(), (float)sprite.method_4575());
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
            buffer.method_22918(positionMatrix, (float)x, y + height, 0.0f).method_39415(color).method_22913(au0, av1).method_1344();
            buffer.method_22918(positionMatrix, (float)x + width, y + height, 0.0f).method_39415(color).method_22913(au1, av1).method_1344();
            buffer.method_22918(positionMatrix, (float)x + width, y, 0.0f).method_39415(color).method_22913(au1, av0).method_1344();
            buffer.method_22918(positionMatrix, (float)x, y, 0.0f).method_39415(color).method_22913(au0, av0).method_1344();
            class_286.method_43433((class_287.class_7433)buffer.method_1326());
            RenderSystem.disableBlend();
        }

        public final void drawFluid(@NotNull class_332 context2, int x, int y, @NotNull FluidReference fluid) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
            if (fluid.isEmpty()) {
                return;
            }
            FluidRenderingBridge bridge = FluidRenderingBridge.Companion.get();
            class_1058 class_10582 = bridge.getStillSprite(fluid);
            if (class_10582 == null) {
                Companion $this$drawFluid_u24lambda_u240 = this;
                boolean bl = false;
                LOGGER.warn("Could not find sprite for {} in brewer screen", (Object)fluid);
                return;
            }
            class_1058 sprite = class_10582;
            int color = ColorsKt.color$default(FluidRenderingBridge.getColor$default(bridge, fluid, null, null, 6, null), 0, 2, null);
            float height = (float)59 * ((float)fluid.getAmount() / (float)((long)2 * fluid.getUnit().getBucketVolume()));
            Ref.IntRef fluidY = new Ref.IntRef();
            int n = class_3532.method_15375((float)(height / (float)16));
            for (int i = 0; i < n; ++i) {
                this.drawSprite(context2, x, (float)y + juuxel.adorn.client.gui.screen.BrewerScreen$Companion.drawFluid$transformY(bridge, fluid, fluidY, 16.0f), 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, sprite, color);
                fluidY.element += 16;
            }
            float leftover = height % (float)16;
            this.drawSprite(context2, x, (float)y + juuxel.adorn.client.gui.screen.BrewerScreen$Companion.drawFluid$transformY(bridge, fluid, fluidY, leftover), 16.0f, leftover, 0.0f, 0.0f, 1.0f, leftover / 16.0f, sprite, color);
        }

        private static final float drawFluid$transformY(FluidRenderingBridge bridge, FluidReference $fluid, Ref.IntRef fluidY, float areaHeight) {
            return bridge.fillsFromTop($fluid) ? (float)fluidY.element : (float)(59 - fluidY.element) - areaHeight;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

