/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.MarkdownParser;
import com.tom.cpl.util.MarkdownRenderer;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.MdResourceIO;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MdResourceLoader
implements MarkdownRenderer.MarkdownResourceLoader {
    public static final String RAW_WIKI_ROOT = "https://raw.githubusercontent.com/wiki/tom5454/CustomPlayerModels/";
    private static final String WIKI_ROOT = "https://github.com/tom5454/CustomPlayerModels/wiki";
    private static final String IMAGES_ROOT = "https://github.com/tom5454/CustomPlayerModels/wiki/images/";
    private static final String LOCALE_ROOT = "https://github.com/tom5454/CustomPlayerModels/wiki/locale/";
    public static final Pattern LOCALE_EXT = Pattern.compile("[\\w-/.:]+\\/([\\w-]+)-([a-z]{2,3}-[A-Z]{2,3})");
    private static final LoadingCache<String, CompletableFuture<Image>> imageCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(CacheLoader.from(MdResourceLoader::loadImage0));
    private static final LoadingCache<String, CompletableFuture<String>> pageCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(CacheLoader.from(MdResourceLoader::loadPage0));
    private boolean offline;
    private Consumer<String> openURL;
    private Consumer<String> nextPage;

    public MdResourceLoader(Consumer<String> openURL, Consumer<String> nextPage, boolean offline) {
        this.offline = offline;
        this.openURL = openURL;
        this.nextPage = nextPage;
    }

    private static CompletableFuture<Image> loadImage0(String url) {
        return MdResourceIO.loadImage0(url, false);
    }

    private static CompletableFuture<String> loadPage0(String url) {
        return MdResourceLoader.fetch(url, false, true).thenApply(pg -> new String((byte[])pg, StandardCharsets.UTF_8));
    }

    @Override
    public CompletableFuture<Image> loadImage(String url) {
        if (this.offline) {
            return MdResourceIO.loadImage0(url, true);
        }
        try {
            return (CompletableFuture)imageCache.get((Object)url);
        }
        catch (ExecutionException e) {
            CompletableFuture<Image> f = new CompletableFuture<Image>();
            f.completeExceptionally(e.getCause());
            return f;
        }
    }

    private CompletableFuture<String> loadPage(String url) {
        if (this.offline) {
            return MdResourceLoader.fetch(url, true, true).thenApply(pg -> new String((byte[])pg, StandardCharsets.UTF_8));
        }
        try {
            return (CompletableFuture)pageCache.get((Object)url);
        }
        catch (ExecutionException e) {
            CompletableFuture<String> f = new CompletableFuture<String>();
            f.completeExceptionally(e.getCause());
            return f;
        }
    }

    @Override
    public void browse(MarkdownRenderer rd, String url) {
        if (url.equals(WIKI_ROOT)) {
            this.browse(rd, "https://github.com/tom5454/CustomPlayerModels/wiki/Home.md");
        } else if (url.startsWith(WIKI_ROOT)) {
            String nm;
            if (this.nextPage != null) {
                this.nextPage.accept(url);
            }
            ((CompletableFuture)this.loadPage((nm = url.substring(url.lastIndexOf(47) + 1)).contains("#") ? url.substring(0, url.lastIndexOf(35)) : url).thenAcceptAsync(pg -> {
                rd.setContent(new MarkdownParser((String)pg));
                if (nm.contains("#")) {
                    rd.browse(nm.substring(nm.indexOf(35)));
                }
            }, rd.getGui()::executeLater)).exceptionally(e -> {
                rd.getGui().executeLater(() -> rd.setContent(MarkdownParser.makeErrorPage(rd.getGui(), e)));
                return null;
            });
        } else if (this.openURL != null) {
            this.openURL.accept(url);
        }
    }

    public static CompletableFuture<byte[]> fetch(String url, boolean offline, boolean logWarn) {
        Log.debug("Wiki fetching: " + url);
        if (url.equals(WIKI_ROOT)) {
            return MdResourceLoader.fetch("https://github.com/tom5454/CustomPlayerModels/wiki/Home.md", offline, logWarn);
        }
        if (url.startsWith(WIKI_ROOT) && url.endsWith(".md")) {
            String p = url.substring(WIKI_ROOT.length() + 1);
            if (offline) {
                return MdResourceLoader.asset0("/assets/cpm/wiki/pages/" + p);
            }
            return MdResourceLoader.fetchOnline(RAW_WIKI_ROOT + p, "/assets/cpm/wiki/pages/" + p, logWarn);
        }
        if (url.startsWith(IMAGES_ROOT)) {
            String p = url.substring(IMAGES_ROOT.length());
            if (offline) {
                return MdResourceLoader.asset0("/assets/cpm/wiki/images/" + p);
            }
            return MdResourceLoader.fetchOnline(RAW_WIKI_ROOT + p, "/assets/cpm/wiki/images/" + p, logWarn);
        }
        if (url.startsWith(WIKI_ROOT)) {
            Matcher m = LOCALE_EXT.matcher(url);
            if (m.matches()) {
                String b = m.group(1);
                String lang = m.group(2);
                CompletableFuture<byte[]> cf = b.equals("_Sidebar") ? MdResourceLoader.fetch(LOCALE_ROOT + lang + "/_Sidebar.md", offline, false) : MdResourceLoader.fetch(LOCALE_ROOT + lang + "/" + b + "-" + lang + ".md", offline, false);
                return ((CompletableFuture)cf.exceptionally(ex -> null)).thenCompose(d -> {
                    if (d == null) {
                        return MdResourceLoader.fetch("https://github.com/tom5454/CustomPlayerModels/wiki/" + b + ".md", offline, logWarn);
                    }
                    return CompletableFuture.completedFuture(d);
                });
            }
            return MdResourceLoader.fetch(url + ".md", offline, logWarn);
        }
        CompletableFuture<byte[]> f = new CompletableFuture<byte[]>();
        f.completeExceptionally(new IOException("Unknown url: " + url));
        return f;
    }

    private static CompletableFuture<byte[]> fetchOnline(String url, String asset, boolean logWarn) {
        return ((CompletableFuture)MdResourceIO.fetch0(url).handle((d, e) -> {
            if (d != null && e == null) {
                return CompletableFuture.completedFuture(d);
            }
            if (logWarn) {
                Log.warn("Failed to load page, loading local backup", e);
            }
            return ((CompletableFuture)MdResourceLoader.asset0(asset).handle((a, e2) -> {
                if (a != null && e2 == null) {
                    return CompletableFuture.completedFuture(a);
                }
                CompletableFuture cf = new CompletableFuture();
                e2.addSuppressed((Throwable)e);
                cf.completeExceptionally((Throwable)e2);
                return cf;
            })).thenCompose(Function.identity());
        })).thenCompose(Function.identity());
    }

    private static CompletableFuture<byte[]> asset0(String path) {
        CompletableFuture<byte[]> completableFuture;
        block9: {
            InputStream is = MdResourceLoader.class.getResourceAsStream(path);
            try {
                if (is == null) {
                    throw new FileNotFoundException(path);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOHelper.copy(is, baos);
                completableFuture = CompletableFuture.completedFuture(baos.toByteArray());
                if (is == null) break block9;
            }
            catch (Throwable baos) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            baos.addSuppressed(throwable);
                        }
                    }
                    throw baos;
                }
                catch (IOException e) {
                    CompletableFuture<byte[]> f = new CompletableFuture<byte[]>();
                    f.completeExceptionally(e);
                    return f;
                }
            }
            is.close();
        }
        return completableFuture;
    }
}

