/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpm.shared.animation.AnimationNew;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.StagedAnimation;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.SerializedAnimation;
import com.tom.cpm.shared.parts.anim.SerializedTrigger;
import com.tom.cpm.shared.parts.anim.TagType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModelPartAnimationNew
implements IModelPart,
IResolvedModelPart {
    private AnimLoaderState state = new AnimLoaderState();

    public ModelPartAnimationNew(IOHelper din, ModelDefinition def) throws IOException {
        while (din.readObjectBlock(TagType.VALUES, TagType.read(this.state)) != TagType.END) {
        }
        this.state.processTriggers();
    }

    public ModelPartAnimationNew(Editor e) {
        this.state.loadFromEditor(e);
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        return this;
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        int i;
        this.state.writeInfo(dout);
        for (i = 0; i < this.state.getTriggers().size(); ++i) {
            SerializedTrigger st = this.state.getTriggers().get(i);
            st.write(dout);
        }
        for (i = 0; i < this.state.getAnims().size(); ++i) {
            SerializedAnimation sa = this.state.getAnims().get(i);
            sa.write(dout);
        }
        dout.writeEnum(TagType.END);
        dout.writeVarInt(0);
    }

    @Override
    public void apply(ModelDefinition def) {
        AnimationRegistry reg = def.getAnimations();
        HashMap<SerializedTrigger, List> anims = new HashMap<SerializedTrigger, List>();
        HashMap convAnims = new HashMap();
        this.state.getAnims().forEach((id, an) -> {
            SerializedTrigger tr = this.state.getTriggers().get(an.triggerID);
            if (tr != null) {
                AnimationNew a = new AnimationNew(an.priority, an.duration);
                an.animatorChannels.values().forEach(ac -> ac.addToAnim(a, def));
                anims.computeIfAbsent(tr, __ -> new ArrayList()).add(a);
                convAnims.put(id, a);
            }
        });
        HashMap st = new HashMap();
        HashMap st2 = new HashMap();
        anims.forEach((tr, ans) -> {
            if (tr.anim != null && tr.anim.isStaged()) {
                SerializedTrigger bt;
                List an;
                if (tr.animID != -1) {
                    IAnimation an2 = (IAnimation)convAnims.get(tr.animID);
                    StagedAnimation san = st.computeIfAbsent(an2, __ -> {
                        StagedAnimation sa = new StagedAnimation();
                        sa.addPlay(an2);
                        return sa;
                    });
                    if (tr.anim == AnimationType.SETUP) {
                        ans.forEach(san::addPre);
                    } else if (tr.anim == AnimationType.FINISH) {
                        ans.forEach(san::addPost);
                    }
                } else if (tr.triggerID != -1 && !(an = anims.getOrDefault(bt = this.state.getTriggers().get(tr.triggerID), Collections.emptyList())).isEmpty()) {
                    StagedAnimation san = st2.computeIfAbsent(bt, __ -> {
                        StagedAnimation sa = new StagedAnimation();
                        an.forEach(sa::addPlay);
                        return sa;
                    });
                    if (tr.anim == AnimationType.SETUP) {
                        ans.forEach(san::addPre);
                    } else if (tr.anim == AnimationType.FINISH) {
                        ans.forEach(san::addPost);
                    }
                }
            }
        });
        anims.forEach((a, b) -> {
            StagedAnimation sa2 = (StagedAnimation)st2.get(a);
            a.registerOld(reg, (sa2 != null ? sa2.getAll() : b).stream().flatMap(an -> {
                StagedAnimation sa = (StagedAnimation)st.get(an);
                if (sa != null) {
                    return sa.getAll().stream();
                }
                return Stream.of(an);
            }).collect(Collectors.toList()));
        });
        this.state.applyInfos(reg);
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.ANIMATION_NEW;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AnimationsNew:\n\tAnimations: ");
        for (int i = 0; i < this.state.getAnims().size(); ++i) {
            SerializedAnimation sa = this.state.getAnims().get(i);
            sb.append("\n\t\t");
            sb.append(i);
            sb.append(": ");
            sb.append("Animation: ");
            sb.append(sa.triggerID);
            sb.append(": ");
            sb.append(String.valueOf(this.state.getTriggers().get(sa.triggerID)).replace("\n", "\n\t\t"));
            sb.append("\n\t\t\t");
            sb.append(sa.toString());
        }
        return sb.toString();
    }
}

