/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.builtin;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpm.shared.model.builtin.SimpleModel;
import com.tom.cpm.shared.model.builtin.VanillaPartRenderer;
import com.tom.cpm.shared.model.render.BoxRender;
import java.util.ArrayList;
import java.util.List;

public class SimplePartRenderer
extends VanillaPartRenderer {
    public boolean mirror;
    private int u;
    private int v;
    private List<SimplePartRenderer> children = new ArrayList<SimplePartRenderer>();
    private SimpleModel model;

    public SimplePartRenderer(SimpleModel model, int u, int v) {
        this.model = model;
        this.u = u;
        this.v = v;
    }

    public void addBox(float x, float y, float z, float w, float h, float d) {
        this.addBox(x, y, z, w, h, d, 0.0f);
    }

    public void addBox(float x, float y, float z, float w, float h, float d, float delta) {
        this.renderer = BoxRender.createTextured(new Vec3f(x, y, z), new Vec3f(w, h, d), new Vec3f(1.0f, 1.0f, 1.0f), delta, this.u, this.v, this.mirror ? -1 : 1, this.model.textureWidth, this.model.textureHeight);
    }

    public void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void addChild(SimplePartRenderer child) {
        this.children.add(child);
    }

    @Override
    public void render(MatrixStack stack, VertexBuffer buf) {
        stack.push();
        this.translateRotatePart(stack);
        if (this.renderer != null) {
            this.renderer.draw(stack, buf, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        this.children.forEach(c -> c.render(stack, buf));
        stack.pop();
    }
}

