/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.Slider;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.actions.ActionBuilder;

public abstract class LayerDefaultPopup
extends PopupPanel {
    protected Editor editor;
    private Checkbox chbxProp;

    protected LayerDefaultPopup(IGui gui, Editor e) {
        super(gui);
        this.editor = e;
        this.chbxProp = new Checkbox(gui, gui.i18nFormat("label.cpm.anim_is_property", new Object[0]));
        String tt = gui.i18nFormat("tooltip.cpm.anim_is_property", new Object[0]);
        if (e.modelId == null) {
            this.chbxProp.setTooltip(new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.anim_is_property.disable", tt)));
        } else {
            this.chbxProp.setTooltip(new Tooltip(gui.getFrame(), tt));
        }
        this.chbxProp.setBounds(new Box(5, 65, 160, 20));
        this.chbxProp.setEnabled(e.modelId != null);
        this.chbxProp.setAction(() -> this.chbxProp.setSelected(!this.chbxProp.isSelected()));
        this.chbxProp.setSelected(e.selectedAnim.isProperty);
        this.addElement(this.chbxProp);
        Button btn = new Button(gui, gui.i18nFormat("button.cpm.ok", new Object[0]), () -> {
            this.close();
            this.apply();
        });
        btn.setBounds(new Box(5, 90, 50, 20));
        this.addElement(btn);
        this.setBounds(new Box(0, 0, 180, 115));
    }

    protected abstract void apply();

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("button.cpm.defLayerSettings", new Object[0]);
    }

    protected ActionBuilder setDefaultLayerValue(float v) {
        return this.editor.action("set", this.gui.i18nFormat("button.cpm.defLayerSettings", new Object[0])).updateValueOp(this.editor.selectedAnim, Float.valueOf(this.editor.selectedAnim.layerDefault), Float.valueOf(v), (a, b) -> {
            a.layerDefault = b.floatValue();
        }).updateValueOp(this.editor.selectedAnim, this.editor.selectedAnim.isProperty, this.chbxProp.isSelected(), (a, b) -> {
            a.isProperty = b;
        });
    }

    public static class Value
    extends LayerDefaultPopup {
        private Slider progressSlider;

        public Value(IGui gui, Editor e) {
            super(gui, e);
            float ld = e.selectedAnim.layerDefault;
            this.progressSlider = new Slider(gui, gui.i18nFormat("label.cpm.defLayerSettings.value", (int)(ld * 100.0f)));
            this.progressSlider.setBounds(new Box(5, 5, 160, 20));
            this.progressSlider.setValue(ld);
            this.progressSlider.setAction(() -> this.progressSlider.setText(gui.i18nFormat("label.cpm.defLayerSettings.value", (int)(this.progressSlider.getValue() * 100.0f))));
            this.addElement(this.progressSlider);
        }

        @Override
        protected void apply() {
            this.setDefaultLayerValue(this.progressSlider.getValue()).execute();
        }
    }

    public static class Toggle
    extends LayerDefaultPopup {
        private Checkbox chbx;
        private TextField groupField;

        public Toggle(IGui gui, Editor e) {
            super(gui, e);
            float ld = e.selectedAnim.layerDefault;
            this.chbx = new Checkbox(gui, gui.i18nFormat("label.cpm.defLayerSettings.toggle", new Object[0]));
            this.chbx.setBounds(new Box(5, 5, 160, 20));
            this.chbx.setAction(() -> this.chbx.setSelected(!this.chbx.isSelected()));
            this.chbx.setSelected(ld != 0.0f);
            this.addElement(this.chbx);
            Label lbl = new Label(gui, gui.i18nFormat("label.cpm.layerGroup", new Object[0]));
            lbl.setBounds(new Box(5, 30, 160, 10));
            lbl.setTooltip(new Tooltip(gui.getFrame(), gui.i18nFormat("tooltip.cpm.layerGroup", new Object[0])));
            this.addElement(lbl);
            this.groupField = new TextField(gui);
            this.groupField.setBounds(new Box(5, 40, 160, 20));
            if (e.selectedAnim.group != null) {
                this.groupField.setText(e.selectedAnim.group);
            }
            this.addElement(this.groupField);
        }

        @Override
        protected void apply() {
            this.setDefaultLayerValue(this.chbx.isSelected() ? 1.0f : 0.0f).updateValueOp(this.editor.selectedAnim, this.editor.selectedAnim.group, this.groupField.getText().isEmpty() ? null : this.groupField.getText(), (a, b) -> {
                a.group = b;
            }).execute();
        }
    }
}

