/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpm.shared.animation.AnimatedTexture;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.Gesture;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.model.CopyTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class AnimationRegistry {
    private List<AnimatedTexture> animatedTextures = new ArrayList<AnimatedTexture>();
    private Map<IPose, List<IAnimation>> animations = new HashMap<IPose, List<IAnimation>>();
    private Map<Integer, IPose> encodedToPose = new HashMap<Integer, IPose>();
    private Map<Integer, Gesture> encodedToGesture = new HashMap<Integer, Gesture>();
    private Map<IPose, Integer> poseToEncoded = new HashMap<IPose, Integer>();
    private Map<Gesture, Integer> gestureToEncoded = new HashMap<Gesture, Integer>();
    private Map<Gesture, Integer> layerToId = new HashMap<Gesture, Integer>();
    private Map<String, Gesture> gestures = new HashMap<String, Gesture>();
    private Map<String, CustomPose> customPoses = new HashMap<String, CustomPose>();
    private List<CopyTransform> copyTransforms = new ArrayList<CopyTransform>();
    private int blankGesture;
    private int poseResetId;
    private String profileId;

    public List<IAnimation> getPoseAnimations(IPose id) {
        return this.animations.getOrDefault(id, Collections.emptyList());
    }

    public IPose getPose(int gesture, IPose pose) {
        return this.encodedToPose.getOrDefault(gesture, pose);
    }

    public Gesture getGesture(int gesture) {
        return this.encodedToGesture.get(gesture);
    }

    public void register(IPose pose, IAnimation anim) {
        this.animations.computeIfAbsent(pose, k -> new ArrayList()).add(anim);
    }

    public void register(int gid, IPose pose) {
        this.encodedToPose.put(gid, pose);
        this.poseToEncoded.put(pose, gid);
    }

    public void register(CustomPose pose) {
        this.customPoses.put(pose.getName(), pose);
    }

    public void register(Gesture gesture) {
        this.gestures.put(gesture.name, gesture);
        if (gesture.getType().isLayer()) {
            this.layerToId.put(gesture, this.layerToId.size() + 2);
        }
    }

    public void register(int gid, Gesture gesture) {
        this.encodedToGesture.put(gid, gesture);
        this.gestureToEncoded.put(gesture, gid);
    }

    public int getEncoded(Gesture g) {
        return this.gestureToEncoded.getOrDefault(g, -1);
    }

    public int getLayerId(Gesture g) {
        return this.layerToId.getOrDefault(g, -1);
    }

    public int getEncoded(CustomPose pose) {
        return this.poseToEncoded.getOrDefault(pose, -1);
    }

    public Map<String, Gesture> getGestures() {
        return this.gestures;
    }

    public Map<String, CustomPose> getCustomPoses() {
        return this.customPoses;
    }

    public int getBlankGesture() {
        return this.blankGesture;
    }

    public void setBlankGesture(int blankGesture) {
        this.blankGesture = blankGesture;
    }

    public void setPoseResetId(int poseResetId) {
        this.poseResetId = poseResetId;
    }

    public int getPoseResetId() {
        return this.poseResetId;
    }

    public void addAnimatedTexture(AnimatedTexture tex) {
        this.animatedTextures.add(tex);
    }

    public void tickAnimated(long time, boolean inGui) {
        for (int i = 0; i < this.animatedTextures.size(); ++i) {
            this.animatedTextures.get(i).update(time, inGui);
        }
    }

    public Map<IPose, List<IAnimation>> getAnimations() {
        return this.animations;
    }

    public boolean hasPoseAnimations(VanillaPose pose) {
        return !this.getPoseAnimations(pose).isEmpty();
    }

    public void addCopy(CopyTransform ct) {
        this.copyTransforms.add(ct);
    }

    public void applyCopy() {
        this.copyTransforms.forEach(CopyTransform::apply);
    }

    public int getLayerCount() {
        return 2 + this.layerToId.size();
    }

    public void forEachLayer(BiConsumer<Gesture, Integer> g) {
        this.layerToId.forEach(g);
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getProfileId() {
        return this.profileId;
    }
}

