/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared;

import com.tom.cpl.command.ArgType;
import com.tom.cpl.command.CommandCtx;
import com.tom.cpl.command.CommandHandler;
import com.tom.cpl.command.LiteralCommandBuilder;
import com.tom.cpl.command.RequiredCommandBuilder;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.Gesture;
import com.tom.cpm.shared.animation.IManualGesture;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.gui.SettingsGui;
import com.tom.cpm.shared.gui.SocialGui;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CommandCPMClient {
    public static void register(CommandHandler<?> dispatcher) {
        LiteralCommandBuilder cpm = (LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)((LiteralCommandBuilder)new LiteralCommandBuilder("cpmclient").then(new LiteralCommandBuilder("profile").then(new RequiredCommandBuilder("player", ArgType.STRING, false).setPossibleValues(() -> CommandCPMClient.getPlayers()).run(c -> CommandCPMClient.openProfile((String)c.getArgument("player")))))).then(new LiteralCommandBuilder("safety").run(c -> CommandCPMClient.openSafety()))).then(new LiteralCommandBuilder("animate").then(((RequiredCommandBuilder)new RequiredCommandBuilder("animation", ArgType.STRING, false).setPossibleValues(c -> CommandCPMClient.getAnimationList(c)).run(c -> CommandCPMClient.setAnimation(c, -1))).then(new RequiredCommandBuilder("value", ArgType.INT, Pair.of(0, 255)).run(c -> CommandCPMClient.setAnimation(c, (Integer)c.getArgument("value"))))))).then(new LiteralCommandBuilder("set_model").then(new RequiredCommandBuilder("model", ArgType.STRING, false).setPossibleValues(c -> CommandCPMClient.getModelsList(c)).run(c -> CommandCPMClient.setModel(c))))).then(new LiteralCommandBuilder("reset_model").run(c -> CommandCPMClient.resetModel()));
        dispatcher.register(cpm, false);
    }

    private static void resetModel() {
        ModConfig.getCommonConfig().clearValue("selectedModel");
        ModConfig.getCommonConfig().save();
        if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
            MinecraftClientAccess.get().sendSkinUpdate();
        }
    }

    private static void setModel(CommandCtx<?> context) {
        if (MinecraftClientAccess.get().getServerSideStatus() != MinecraftClientAccess.ServerStatus.INSTALLED) {
            context.fail(new FormatText("label.cpm.feature_unavailable", new Object[0]));
            return;
        }
        String modelF = (String)context.getArgument("model");
        if (!CommandCPMClient.getModelsList(context).contains(modelF)) {
            context.fail(new FormatText("commands.cpmclient.set_model.not_found", modelF));
            return;
        }
        ModConfig.getCommonConfig().setString("selectedModel", modelF);
        ModConfig.getCommonConfig().save();
        MinecraftClientAccess.get().sendSkinUpdate();
    }

    private static List<String> getModelsList(CommandCtx<?> c) {
        ArrayList<String> l = new ArrayList<String>();
        File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
        if (modelsDir.exists()) {
            CommandCPMClient.walkDirs(modelsDir, null, l);
        }
        return l;
    }

    private static void walkDirs(File d, String path, List<String> l) {
        File[] fs = d.listFiles((f, n) -> n.endsWith(".cpmmodel") || new File(f, n).isDirectory());
        for (int i = 0; i < fs.length; ++i) {
            String p;
            File f2 = fs[i];
            if (f2.getName().equals(".temp.cpmmodel") || f2.getName().equals("autosaves")) continue;
            String string = p = path != null ? path + "/" + f2.getName() : f2.getName();
            if (f2.isDirectory()) {
                CommandCPMClient.walkDirs(f2, p, l);
                continue;
            }
            l.add(p);
        }
    }

    private static void openProfile(String player) {
        ModelDefinitionLoader d = MinecraftClientAccess.get().getDefinitionLoader();
        for (Object gp : MinecraftClientAccess.get().getPlayers()) {
            if (!player.equals(d.getGP_Name(gp))) continue;
            UUID uuid = d.getGP_UUID(gp);
            CommandCPMClient.openGui(g -> new SocialGui((IGui)g, uuid));
            return;
        }
    }

    private static List<String> getPlayers() {
        ModelDefinitionLoader d = MinecraftClientAccess.get().getDefinitionLoader();
        return MinecraftClientAccess.get().getPlayers().stream().map(d::getGP_Name).filter(e -> e != null).collect(Collectors.toList());
    }

    private static void openSafety() {
        CommandCPMClient.openGui(SettingsGui::safetySettings);
    }

    private static void openGui(Function<IGui, Frame> creator) {
        MinecraftClientAccess.get().executeNextFrame(() -> MinecraftClientAccess.get().openGui(creator));
    }

    private static List<String> getAnimationList(CommandCtx<?> context) {
        ArrayList<String> l = new ArrayList<String>();
        Player<?> player = MinecraftClientAccess.get().getCurrentClientPlayer();
        ModelDefinition def = player.getModelDefinition();
        if (def != null) {
            AnimationRegistry ar = def.getAnimations();
            ar.getCustomPoses().values().stream().filter(p -> CommandCPMClient.canPlay(p)).forEach(p -> l.add(p.getName()));
            ar.getGestures().values().stream().filter(p -> CommandCPMClient.canPlay(p)).forEach(p -> l.add(p.getName()));
        }
        return l;
    }

    private static boolean canPlay(IManualGesture p) {
        return !p.isCommand() || p.getName().startsWith("client:");
    }

    private static void setAnimation(CommandCtx<?> context, int value) {
        String id = (String)context.getArgument("animation");
        if (!CommandCPMClient.playAnimation(id, value)) {
            context.fail(new FormatText("commands.cpmclient.animate.invalid", id));
        }
    }

    private static boolean playAnimation(String id, int value) {
        AnimationEngine an = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine();
        Player<?> pl = MinecraftClientAccess.get().getCurrentClientPlayer();
        ModelDefinition def = pl.getModelDefinition();
        if (def != null) {
            CustomPose pose = def.getAnimations().getCustomPoses().get(id);
            if (pose != null) {
                if (!CommandCPMClient.canPlay(pose)) {
                    return false;
                }
                if (value == 0) {
                    an.setCustomPose(def.getAnimations(), null);
                } else {
                    an.setCustomPose(def.getAnimations(), pose, false);
                }
                return true;
            }
            Gesture g = def.getAnimations().getGestures().get(id);
            if (g != null && CommandCPMClient.canPlay(g)) {
                if (g.type.isLayer() && value != -1) {
                    an.setLayerValue(def.getAnimations(), g, (float)value / 255.0f);
                    return true;
                }
                if (value == 0) {
                    an.playGesture(def.getAnimations(), null, pl);
                } else {
                    an.playGesture(def.getAnimations(), g, false, pl);
                }
                return true;
            }
        }
        return false;
    }
}

