/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.screen;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.CraftingInventoryImproved;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.InventoryImproved;
import com.tiviacz.travelersbackpack.inventory.screen.slot.BackpackSlot;
import com.tiviacz.travelersbackpack.inventory.screen.slot.FluidSlot;
import com.tiviacz.travelersbackpack.inventory.screen.slot.ToolSlot;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1731;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackBaseScreenHandler
extends class_1703 {
    public class_1661 playerInventory;
    public ITravelersBackpackInventory inventory;
    public CraftingInventoryImproved craftMatrix;
    public class_1731 craftResult = new class_1731();
    private final int BACKPACK_INV_START = 1;
    private final int BACKPACK_INV_END;
    private final int TOOL_START;
    private final int TOOL_END;
    private final int BUCKET_LEFT_IN;
    private final int BUCKET_LEFT_OUT;
    private final int BUCKET_RIGHT_IN;
    private final int BUCKET_RIGHT_OUT;
    private final int PLAYER_INV_START;
    private final int PLAYER_HOT_END;
    private final int CRAFTING_GRID_START;
    private final int CRAFTING_GRID_END;

    protected TravelersBackpackBaseScreenHandler(@Nullable class_3917<?> type, int syncId, class_1661 playerInventory, ITravelersBackpackInventory inventory) {
        super(type, syncId);
        this.playerInventory = playerInventory;
        this.inventory = inventory;
        this.craftMatrix = new CraftingInventoryImproved(inventory, this);
        this.BACKPACK_INV_END = 1 + inventory.getInventory().method_5439() - 1;
        this.TOOL_START = this.BACKPACK_INV_END + 1;
        this.TOOL_END = this.TOOL_START + inventory.getToolSlotsInventory().method_5439() - 1;
        this.BUCKET_LEFT_IN = this.TOOL_END + 1;
        this.BUCKET_LEFT_OUT = this.BUCKET_LEFT_IN + 1;
        this.BUCKET_RIGHT_IN = this.BUCKET_LEFT_OUT + 1;
        this.BUCKET_RIGHT_OUT = this.BUCKET_RIGHT_IN + 1;
        this.CRAFTING_GRID_START = this.BUCKET_RIGHT_OUT + 1;
        this.CRAFTING_GRID_END = this.CRAFTING_GRID_START + 8;
        this.PLAYER_INV_START = this.CRAFTING_GRID_END + 1;
        this.PLAYER_HOT_END = this.PLAYER_INV_START + 35;
        this.addCraftResult();
        this.addBackpackInventory(inventory);
        this.addToolSlots(inventory);
        this.addFluidSlots(inventory);
        this.addCraftingSlots();
        this.addPlayerInventoryAndHotbar(playerInventory, playerInventory.field_7545);
    }

    public void addCraftResult() {
        this.method_7621((class_1735)new class_1734(this.playerInventory.field_7546, this.craftMatrix, (class_1263)this.craftResult, 0, 270, 113){

            public boolean method_7674(class_1657 playerEntity) {
                return TravelersBackpackBaseScreenHandler.this.inventory.getSettingsManager().hasCraftingGrid();
            }

            public boolean method_7682() {
                return TravelersBackpackBaseScreenHandler.this.inventory.getSettingsManager().hasCraftingGrid() && TravelersBackpackBaseScreenHandler.this.inventory.getSettingsManager().showCraftingGrid();
            }
        });
    }

    public void addBackpackInventory(ITravelersBackpackInventory inventory) {
        int slot = 0;
        for (int i = 0; i < inventory.getRows(); ++i) {
            int lastRowSlots = inventory.getInventory().method_5439() % 9;
            if (lastRowSlots == 0) {
                lastRowSlots = 9;
            }
            int slotsInRow = i == inventory.getRows() - 1 ? lastRowSlots : 9;
            for (int j = 0; j < slotsInRow; ++j) {
                this.method_7621(new BackpackSlot(inventory.getInventory(), slot++, 44 + j * 18, 7 + i * 18));
            }
        }
    }

    public void addFluidSlots(ITravelersBackpackInventory inventory) {
        this.method_7621(new FluidSlot(inventory, 0, 6, 7){

            @Override
            public boolean method_7682() {
                return !TravelersBackpackBaseScreenHandler.this.inventory.getSettingsManager().showToolSlots() && super.method_7682();
            }
        });
        this.method_7621(new FluidSlot(inventory, 1, 6, 37){

            @Override
            public boolean method_7682() {
                return !TravelersBackpackBaseScreenHandler.this.inventory.getSettingsManager().showToolSlots() && super.method_7682();
            }
        });
        this.method_7621(new FluidSlot(inventory, 2, 226, 7));
        this.method_7621(new FluidSlot(inventory, 3, 226, 37));
    }

    public void addToolSlots(ITravelersBackpackInventory inventory) {
        for (int i = 0; i < inventory.getToolSlotsInventory().method_5439(); ++i) {
            this.method_7621(new ToolSlot(this.playerInventory.field_7546, inventory, i, 6, 7 + 18 * i));
        }
    }

    public void addCraftingSlots() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.method_7621(new class_1735((class_1263)this.craftMatrix, j + i * 3, 252 + j * 18, 47 + i * 18){

                    public boolean method_7682() {
                        return TravelersBackpackBaseScreenHandler.this.inventory.getSettingsManager().showCraftingGrid();
                    }
                });
            }
        }
    }

    public void addPlayerInventoryAndHotbar(class_1661 playerInv, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)playerInv, x + y * 9 + 9, 44 + x * 18, 71 + this.inventory.getYOffset() + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)playerInv, x, 44 + x * 18, 129 + this.inventory.getYOffset()));
        }
    }

    protected void canCraft(class_1937 world, class_1657 player) {
        if (this.inventory.getSettingsManager().hasCraftingGrid()) {
            TravelersBackpackBaseScreenHandler.slotChangedCraftingGrid(this, world, player, this.craftMatrix, this.craftResult);
        }
    }

    public void method_7609(class_1263 inventory) {
        super.method_7609(inventory);
        this.canCraft(this.playerInventory.field_7546.method_37908(), this.playerInventory.field_7546);
    }

    public void method_34252() {
        super.method_34252();
        this.method_7609(this.inventory.getCraftingGridInventory());
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.craftResult && super.method_7613(stack, slot);
    }

    protected static void slotChangedCraftingGrid(class_1703 handler, class_1937 world, class_1657 player, class_8566 craftMatrix, class_1731 craftResult) {
        if (!world.field_9236) {
            class_8786 craftingRecipeEntry;
            class_3222 serverPlayerEntity = (class_3222)player;
            class_1799 itemStack = class_1799.field_8037;
            Optional optional = world.method_8503().method_3772().method_8132(class_3956.field_17545, (class_1263)craftMatrix, world);
            if (optional.isPresent() && craftResult.method_7665(world, serverPlayerEntity, craftingRecipeEntry = (class_8786)optional.get())) {
                itemStack = ((class_3955)craftingRecipeEntry.comp_1933()).method_8116((class_1263)craftMatrix, world.method_30349());
            }
            craftResult.method_5447(0, itemStack);
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(handler.field_7763, handler.method_37421(), 0, itemStack));
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 slot = this.method_7611(index);
        class_1799 result = class_1799.field_8037;
        if (slot != null && slot.method_7681()) {
            class_1799 stack = slot.method_7677();
            result = stack.method_7972();
            if (index >= 0 && index <= this.CRAFTING_GRID_END) {
                if (index == 0) {
                    stack.method_7909().method_54465(stack, player.method_37908(), player);
                    if (this.inventory.getSettingsManager().shiftClickToBackpack() ? !this.method_7616(stack, 1, this.BACKPACK_INV_END + 1, false) : !this.method_7616(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END + 1, true)) {
                        return class_1799.field_8037;
                    }
                    slot.method_7670(stack, result);
                    this.craftMatrix.method_5431();
                } else if (!this.method_7616(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END + 1, true)) {
                    return class_1799.field_8037;
                }
            }
            if (index >= this.PLAYER_INV_START) {
                if (!this.inventory.getSlotManager().getMemorySlots().isEmpty()) {
                    Pair<Integer, class_1799> pair;
                    Iterator<Pair<Integer, class_1799>> iterator = this.inventory.getSlotManager().getMemorySlots().iterator();
                    while (!(!iterator.hasNext() || ItemStackUtils.canCombine((class_1799)(pair = iterator.next()).getSecond(), stack) && this.method_7611((Integer)pair.getFirst() + 1).method_7677().method_7947() != this.method_7611((Integer)pair.getFirst() + 1).method_7677().method_7914() && this.method_7616(stack, (Integer)pair.getFirst() + 1, (Integer)pair.getFirst() + 2, false))) {
                    }
                }
                if (ToolSlot.isValid(stack) && !this.method_7616(stack, this.TOOL_START, this.TOOL_END + 1, false) && !this.method_7616(stack, 1, this.BACKPACK_INV_END + 1, false)) {
                    return class_1799.field_8037;
                }
                if (!this.method_7616(stack, 1, this.BACKPACK_INV_END + 1, false)) {
                    return class_1799.field_8037;
                }
            }
            if (stack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (stack.method_7947() == result.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, stack);
        }
        return result;
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (this.inventory.getSlotManager().isSelectorActive((byte)0) || this.inventory.getSlotManager().isSelectorActive((byte)1)) {
            return;
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        if (this.inventory.getScreenID() != 3) {
            this.inventory.markDataDirty(11);
        }
        if (this.inventory.getScreenID() == 3) {
            if (this.inventory.getSlotManager().isSelectorActive((byte)0) || this.inventory.getSlotManager().isSelectorActive((byte)1)) {
                this.inventory.getSlotManager().setChanged();
            }
            this.inventory.setUsingPlayer(null);
        }
        if (this.inventory.getSlotManager().isSelectorActive((byte)0)) {
            this.inventory.getSlotManager().setSelectorActive((byte)0, false);
        }
        if (this.inventory.getSlotManager().isSelectorActive((byte)1)) {
            this.inventory.getSlotManager().setSelectorActive((byte)1, false);
        }
        this.clearSlotsAndPlaySound(playerIn, this.inventory.getFluidSlotsInventory(), 4);
        this.shiftTools(this.inventory);
        if (!TravelersBackpackConfig.getConfig().backpackSettings.craftingSavesItems) {
            this.clearSlotsAndPlaySound(playerIn, this.inventory.getCraftingGridInventory(), 9);
        } else {
            this.checkCraftingGridAndPlaySound(playerIn);
        }
    }

    public void clearSlotsAndPlaySound(class_1657 player, InventoryImproved inventoryImproved, int size) {
        boolean playSound = false;
        for (int i = 0; i < size; ++i) {
            boolean flag = this.clearSlot(player, inventoryImproved, i);
            if (!flag) continue;
            playSound = true;
        }
        if (playSound) {
            this.playSound(player);
        }
    }

    public boolean clearSlot(class_1657 player, InventoryImproved inventoryImproved, int index) {
        if (!inventoryImproved.method_5438(index).method_7960()) {
            class_3222 serverPlayer;
            if (player == null) {
                return false;
            }
            if (!player.method_5805() || player instanceof class_3222 && (serverPlayer = (class_3222)player).method_14239()) {
                class_1799 stack = inventoryImproved.method_5438(index).method_7972();
                inventoryImproved.method_5447(index, class_1799.field_8037);
                player.method_7328(stack, false);
                return false;
            }
            class_1799 stack = inventoryImproved.method_5438(index);
            inventoryImproved.method_5447(index, class_1799.field_8037);
            player.method_31548().method_7398(stack);
            return true;
        }
        return false;
    }

    public void shiftTools(ITravelersBackpackInventory inventory) {
        boolean foundEmptySlot = false;
        boolean needsShifting = false;
        for (int i = 0; i < inventory.getToolSlotsInventory().method_5439(); ++i) {
            if (foundEmptySlot && !inventory.getToolSlotsInventory().method_5438(i).method_7960()) {
                needsShifting = true;
            }
            if (!inventory.getToolSlotsInventory().method_5438(i).method_7960() || foundEmptySlot) continue;
            foundEmptySlot = true;
        }
        if (needsShifting) {
            int i;
            class_2371 tools = class_2371.method_10213((int)inventory.getToolSlotsInventory().method_5439(), (Object)class_1799.field_8037);
            int j = 0;
            for (i = 0; i < inventory.getToolSlotsInventory().method_5439(); ++i) {
                if (inventory.getToolSlotsInventory().method_5438(i).method_7960()) continue;
                tools.set(j, (Object)inventory.getToolSlotsInventory().method_5438(i));
                ++j;
            }
            j = 0;
            for (i = 0; i < inventory.getToolSlotsInventory().method_5439(); ++i) {
                if (tools.isEmpty()) continue;
                inventory.getToolSlotsInventory().method_5447(i, (class_1799)tools.get(j));
                ++j;
            }
        }
    }

    public void playSound(class_1657 playerIn) {
        playerIn.method_37908().method_8396(playerIn, playerIn.method_24515(), class_3417.field_15197, class_3419.field_15245, 1.0f, (1.0f + (playerIn.method_37908().field_9229.method_43057() - playerIn.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
    }

    public void checkCraftingGridAndPlaySound(class_1657 player) {
        boolean playSound = false;
        for (int i = 0; i < this.inventory.getCraftingGridInventory().method_5439(); ++i) {
            boolean flag = this.clearCraftingGridSlot(player, i);
            if (!flag) continue;
            playSound = true;
        }
        if (playSound) {
            this.playSound(player);
        }
    }

    public boolean clearCraftingGridSlot(class_1657 player, int index) {
        if (!BackpackSlot.isValid(this.inventory.getCraftingGridInventory().method_5438(index))) {
            class_3222 serverPlayer;
            if (player == null) {
                return false;
            }
            if (!player.method_5805() || player instanceof class_3222 && (serverPlayer = (class_3222)player).method_14239()) {
                class_1799 stack = this.inventory.getCraftingGridInventory().method_5438(index).method_7972();
                this.inventory.getCraftingGridInventory().method_5447(index, class_1799.field_8037);
                player.method_7328(stack, false);
            } else {
                class_1799 stack = this.inventory.getCraftingGridInventory().method_5438(index);
                this.inventory.getCraftingGridInventory().method_5447(index, class_1799.field_8037);
                player.method_31548().method_7398(stack);
            }
        }
        return false;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }
}

