/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="travelersbackpack")
public class TravelersBackpackConfigData
implements ConfigData {
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.CollapsibleObject
    public BackpackSettings backpackSettings = new BackpackSettings();
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.CollapsibleObject
    public World world = new World();
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.CollapsibleObject
    public BackpackAbilities backpackAbilities = new BackpackAbilities();
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.CollapsibleObject
    public SlownessDebuff slownessDebuff = new SlownessDebuff();
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.CollapsibleObject
    public Client client = new Client();

    public static class BackpackSettings {
        @ConfigEntry.Gui.CollapsibleObject
        public LeatherTierConfig leather = new LeatherTierConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public IronTierConfig iron = new IronTierConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public GoldTierConfig gold = new GoldTierConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public DiamondTierConfig diamond = new DiamondTierConfig();
        @ConfigEntry.Gui.CollapsibleObject
        public NetheriteTierConfig netherite = new NetheriteTierConfig();
        @ConfigEntry.Gui.RequiresRestart
        public boolean enableTierUpgrades = true;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Unused - keep for compatibility only, will be removed in future versions")
        public boolean disableCrafting = false;
        @ConfigEntry.Gui.RequiresRestart
        public boolean enableCraftingUpgrade = true;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="New backpacks will have crafting grid by default")
        public boolean craftingUpgradeByDefault = false;
        @ConfigEntry.Gui.RequiresRestart
        public boolean craftingSavesItems = true;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Enables wearing backpack directly from ground")
        public boolean enableBackpackBlockQuickEquip = true;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Enables unequipping the backpack when player clicks with empty hand on the ground")
        public boolean enableBackpackRightClickUnequip = false;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Backpack immune to any damage source (lava, fire), can't be destroyed, never disappears as floating item")
        public boolean invulnerableBackpack = true;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="List of items that can be put in tool slots (Use registry names, for example: minecraft:apple, minecraft:flint)")
        public String[] toolSlotsAcceptableItems = new String[0];
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="List of items that can't be put in backpack inventory (Use registry names, for example: minecraft:apple, minecraft:flint)")
        public String[] blacklistedItems = new String[0];
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Tool slots accept any item")
        public boolean toolSlotsAcceptEverything = false;
        @ConfigEntry.Gui.RequiresRestart
        public boolean allowShulkerBoxes = false;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Unused - keep for compatibility only, will be removed in future versions")
        public long[] tanksCapacity = new long[]{162000L, 243000L, 324000L, 405000L, 486000L};
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Prevents backpack disappearing in void")
        public boolean voidProtection = true;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Places backpack at place where player died")
        public boolean backpackDeathPlace = true;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Places backpack at place where player died, replacing all blocks that are breakable and do not have inventory (backpackDeathPlace must be true in order to work)")
        public boolean backpackForceDeathPlace = false;
        @ConfigEntry.Gui.RequiresRestart
        public boolean enableSleepingBagSpawnPoint = false;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="If true, backpack can only be worn by placing it in curios 'Back' slot\nWARNING - Remember to TAKE OFF BACKPACK BEFORE enabling or disabling this integration!! - if not you'll lose your backpack")
        public boolean trinketsIntegration = false;
    }

    public static class World {
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Enables backpacks spawning in loot chests")
        public boolean enableLoot = true;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Enables chance to spawn Zombie, Skeleton, Wither Skeleton, Piglin or Enderman with random backpack equipped")
        public boolean spawnEntitiesWithBackpack = true;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="List of overworld entity types that can spawn with equipped backpack. DO NOT ADD anything to this list, because the game will crash, remove entries if mob should not spawn with backpack")
        public String[] possibleOverworldEntityTypes = new String[]{"minecraft:zombie", "minecraft:skeleton", "minecraft:enderman"};
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="List of nether entity types that can spawn with equipped backpack. DO NOT ADD anything to this list, because the game will crash, remove entries if mob should not spawn with backpack")
        public String[] possibleNetherEntityTypes = new String[]{"minecraft:wither_skeleton", "minecraft:piglin"};
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Defines spawn chance of entity with backpack (1 in [selected value])")
        public int spawnChance = 500;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="List of backpacks that can spawn on overworld mobs")
        public String[] overworldBackpacks = new String[]{"travelersbackpack:standard", "travelersbackpack:diamond", "travelersbackpack:gold", "travelersbackpack:emerald", "travelersbackpack:iron", "travelersbackpack:lapis", "travelersbackpack:redstone", "travelersbackpack:coal", "travelersbackpack:bookshelf", "travelersbackpack:sandstone", "travelersbackpack:snow", "travelersbackpack:sponge", "travelersbackpack:cake", "travelersbackpack:cactus", "travelersbackpack:hay", "travelersbackpack:melon", "travelersbackpack:pumpkin", "travelersbackpack:creeper", "travelersbackpack:enderman", "travelersbackpack:skeleton", "travelersbackpack:spider", "travelersbackpack:bee", "travelersbackpack:wolf", "travelersbackpack:fox", "travelersbackpack:ocelot", "travelersbackpack:horse", "travelersbackpack:cow", "travelersbackpack:pig", "travelersbackpack:sheep", "travelersbackpack:chicken", "travelersbackpack:squid"};
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="List of backpacks that can spawn on nether mobs")
        public String[] netherBackpacks = new String[]{"travelersbackpack:quartz", "travelersbackpack:nether", "travelersbackpack:blaze", "travelersbackpack:ghast", "travelersbackpack:magma_cube", "travelersbackpack:wither"};
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Enables trade for Villager Backpack in Librarian villager trades")
        public boolean enableVillagerTrade = true;
    }

    public static class BackpackAbilities {
        @ConfigEntry.Gui.RequiresRestart
        public boolean enableBackpackAbilities = true;
        @ConfigEntry.Gui.RequiresRestart
        public boolean forceAbilityEnabled = false;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="List of backpacks that are allowed to have an ability. DO NOT ADD anything to this list, because the game will crash, remove entries if backpack should not have ability")
        public String[] allowedAbilities = new String[]{"travelersbackpack:netherite", "travelersbackpack:diamond", "travelersbackpack:gold", "travelersbackpack:emerald", "travelersbackpack:iron", "travelersbackpack:lapis", "travelersbackpack:redstone", "travelersbackpack:bookshelf", "travelersbackpack:sponge", "travelersbackpack:cake", "travelersbackpack:cactus", "travelersbackpack:melon", "travelersbackpack:pumpkin", "travelersbackpack:creeper", "travelersbackpack:dragon", "travelersbackpack:enderman", "travelersbackpack:blaze", "travelersbackpack:ghast", "travelersbackpack:magma_cube", "travelersbackpack:spider", "travelersbackpack:wither", "travelersbackpack:bat", "travelersbackpack:bee", "travelersbackpack:ocelot", "travelersbackpack:cow", "travelersbackpack:chicken", "travelersbackpack:squid"};
    }

    public static class SlownessDebuff {
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Player gets slowness effect, if carries too many backpacks in inventory")
        public boolean tooManyBackpacksSlowness = true;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.BoundedDiscrete(min=1L, max=37L)
        @Comment(value="Maximum number of backpacks, which can be carried in inventory, without slowness effect")
        public int maxNumberOfBackpacks = 3;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.BoundedDiscrete(min=1L, max=5L)
        public int slownessPerExcessedBackpack = 1;
    }

    public static class Client {
        @ConfigEntry.Gui.CollapsibleObject
        public Overlay overlay = new Overlay();
        @Comment(value="Enables legacy GUI (Blue slots for storage, brown for crafting and green for tools)")
        public boolean enableLegacyGui = false;
        @Comment(value="Enables tool cycling via keybind (Default Z) + scroll combination, while backpack is worn")
        public boolean enableToolCycling = true;
        @Comment(value="Allows tool cycling using keybinding only (Default Z)")
        public boolean disableScrollWheel = false;
        @Comment(value="Enables tip, how to obtain a backpack, if there's no crafting recipe for it")
        public boolean obtainTips = true;
        @Comment(value="Render tools in tool slots on the backpack, while worn")
        public boolean renderTools = true;
        @Comment(value="Render backpack if elytra is present")
        public boolean renderBackpackWithElytra = true;
        @Comment(value="Disable backpack rendering")
        public boolean disableBackpackRender = false;

        public static class Overlay {
            @Comment(value="Enables tanks and tool slots overlay, while backpack is worn")
            public boolean enableOverlay = true;
            @Comment(value="Offsets to left side")
            public int offsetX = 20;
            @Comment(value="Offsets to up")
            public int offsetY = 30;
        }
    }

    public static class NetheriteTierConfig {
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Number of inventory slots for the tier")
        @ConfigEntry.BoundedDiscrete(min=1L, max=63L)
        public int inventorySlotCount = 63;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Number of tool slots for the tier")
        @ConfigEntry.BoundedDiscrete(min=0L, max=6L)
        public int toolSlotCount = 6;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Tank capacity for the tier, 81000 equals 1 Bucket, (Netherite default: 7 buckets)")
        public long tankCapacity = 567000L;
    }

    public static class DiamondTierConfig {
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Number of inventory slots for the tier")
        @ConfigEntry.BoundedDiscrete(min=1L, max=63L)
        public int inventorySlotCount = 54;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Number of tool slots for the tier")
        @ConfigEntry.BoundedDiscrete(min=0L, max=6L)
        public int toolSlotCount = 5;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Tank capacity for the tier, 81000 equals 1 Bucket, (Diamond default: 6 buckets)")
        public long tankCapacity = 486000L;
    }

    public static class GoldTierConfig {
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Number of inventory slots for the tier")
        @ConfigEntry.BoundedDiscrete(min=1L, max=63L)
        public int inventorySlotCount = 45;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Number of tool slots for the tier")
        @ConfigEntry.BoundedDiscrete(min=0L, max=6L)
        public int toolSlotCount = 4;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Tank capacity for the tier, 81000 equals 1 Bucket, (Gold default: 5 buckets)")
        public long tankCapacity = 405000L;
    }

    public static class IronTierConfig {
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Number of inventory slots for the tier")
        @ConfigEntry.BoundedDiscrete(min=1L, max=63L)
        public int inventorySlotCount = 36;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Number of tool slots for the tier")
        @ConfigEntry.BoundedDiscrete(min=0L, max=6L)
        public int toolSlotCount = 3;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Tank capacity for the tier, 81000 equals 1 Bucket, (Iron default: 4 buckets)")
        public long tankCapacity = 324000L;
    }

    public static class LeatherTierConfig {
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Number of inventory slots for the tier")
        @ConfigEntry.BoundedDiscrete(min=1L, max=63L)
        public int inventorySlotCount = 27;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Number of tool slots for the tier")
        @ConfigEntry.BoundedDiscrete(min=0L, max=6L)
        public int toolSlotCount = 2;
        @ConfigEntry.Gui.RequiresRestart
        @Comment(value="Tank capacity for the tier, 81000 equals 1 Bucket, (Leather default: 3 buckets)")
        public long tankCapacity = 243000L;
    }
}

