/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.init.ModCrafting;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class ShapelessBackpackRecipe
extends class_1867 {
    public ShapelessBackpackRecipe(String group, class_7710 category, class_1799 output, class_2371<class_1856> input) {
        super(group, category, output, input);
    }

    public class_1799 method_17729(class_8566 inv, class_5455 manager) {
        class_1799 output = super.method_17729(inv, manager);
        if (!output.method_7960()) {
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 ingredient = inv.method_5438(i);
                if (ingredient.method_7960() || !(ingredient.method_7909() instanceof TravelersBackpackItem)) continue;
                class_2487 compound = ingredient.method_7969();
                output.method_7980(compound);
                break;
            }
        }
        return output;
    }

    private class_1799 damageShears(class_1799 stack) {
        Object craftingPlayer = null;
        if (stack.method_7970(1, craftingPlayer == null ? class_5819.method_43047() : craftingPlayer.method_37908().field_9229, craftingPlayer instanceof class_3222 ? (class_3222)craftingPlayer : null)) {
            return class_1799.field_8037;
        }
        return stack;
    }

    public class_2371<class_1799> getRemainder(class_8566 inventoryCrafting) {
        class_2371 remainingItems = class_2371.method_10213((int)inventoryCrafting.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < remainingItems.size(); ++i) {
            class_1799 itemstack = inventoryCrafting.method_5438(i);
            if (!itemstack.method_7960() && itemstack.method_7909() instanceof class_1820) {
                remainingItems.set(i, (Object)this.damageShears(itemstack.method_7972()));
            }
            if (!itemstack.method_7909().method_7857()) continue;
            remainingItems.set(i, (Object)new class_1799((class_1935)itemstack.method_7909().method_7858()));
        }
        return remainingItems;
    }

    public class_1865<?> method_8119() {
        return ModCrafting.BACKPACK_SHAPELESS;
    }

    public static class Serializer
    implements class_1865<ShapelessBackpackRecipe> {
        private static final Codec<ShapelessBackpackRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_53049((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(recipe -> recipe.method_8112()), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(recipe -> recipe.method_45441()), (App)class_1799.field_47309.fieldOf("result").forGetter(recipe -> recipe.field_9050), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] ingredients2 = (class_1856[])ingredients.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
            if (ingredients2.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return ingredients2.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients2));
        }, DataResult::success).forGetter(recipe -> recipe.method_8117())).apply((Applicative)instance, ShapelessBackpackRecipe::new));

        public Codec<ShapelessBackpackRecipe> method_53736() {
            return CODEC;
        }

        public ShapelessBackpackRecipe read(class_2540 packetByteBuf) {
            String string = packetByteBuf.method_19772();
            class_7710 craftingRecipeCategory = (class_7710)packetByteBuf.method_10818(class_7710.class);
            int i = packetByteBuf.method_10816();
            class_2371 defaultedList = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < defaultedList.size(); ++j) {
                defaultedList.set(j, (Object)class_1856.method_8086((class_2540)packetByteBuf));
            }
            class_1799 itemStack = packetByteBuf.method_10819();
            return new ShapelessBackpackRecipe(string, craftingRecipeCategory, itemStack, (class_2371<class_1856>)defaultedList);
        }

        public void write(class_2540 packetByteBuf, ShapelessBackpackRecipe shapelessRecipe) {
            packetByteBuf.method_10814(shapelessRecipe.method_8112());
            packetByteBuf.method_10817((Enum)shapelessRecipe.method_45441());
            packetByteBuf.method_10804(shapelessRecipe.method_8117().size());
            for (class_1856 ingredient : shapelessRecipe.method_8117()) {
                ingredient.method_8088(packetByteBuf);
            }
            packetByteBuf.method_10793(shapelessRecipe.field_9050);
        }
    }
}

