/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screen.TravelersBackpackHandledScreen;
import com.tiviacz.travelersbackpack.util.FluidUtils;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_8630;

public class TankScreen {
    private final int height;
    private final int width;
    private final int startX;
    private final int startY;
    private final SingleVariantStorage<FluidVariant> tank;

    public TankScreen(SingleVariantStorage<FluidVariant> tank, int x, int y, int height, int width) {
        this.startX = x;
        this.startY = y;
        this.height = height;
        this.width = width;
        this.tank = tank;
    }

    public List<class_2561> getTankTooltip(class_1937 world) {
        FluidVariant fluidVariant = (FluidVariant)this.tank.getResource();
        ArrayList<class_2561> tankTips = new ArrayList<class_2561>();
        String fluidName = !fluidVariant.isBlank() ? FluidVariantAttributes.getName((FluidVariant)fluidVariant).getString() : class_1074.method_4662((String)"screen.travelersbackpack.none", (Object[])new Object[0]);
        Object fluidAmount = class_1074.method_4662((String)"screen.travelersbackpack.empty", (Object[])new Object[0]);
        if (!fluidVariant.isBlank()) {
            float amount = (float)this.tank.getAmount() / 81.0f;
            float capacity = (float)this.tank.getCapacity() / 81.0f;
            fluidAmount = (int)amount + "/" + (int)capacity;
        }
        if (!fluidVariant.isBlank() && fluidVariant.hasNbt() && fluidVariant.getNbt().method_10545("Potion")) {
            fluidName = null;
            TankScreen.buildTooltip(FluidUtils.getItemStackFromFluidStack(fluidVariant), tankTips, world);
        }
        if (fluidName != null) {
            tankTips.add((class_2561)class_2561.method_43470((String)fluidName));
        }
        tankTips.add((class_2561)class_2561.method_43470((String)fluidAmount));
        return tankTips;
    }

    public static void buildTooltip(class_1799 stack, List<class_2561> list, class_1937 world) {
        List statusEffects = class_1844.method_8067((class_1799)stack);
        ArrayList list2 = Lists.newArrayList();
        if (statusEffects.isEmpty()) {
            list.add((class_2561)class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080));
        } else {
            for (class_1293 statusEffectInstance : statusEffects) {
                class_5250 mutableText = class_2561.method_43471((String)statusEffectInstance.method_5586());
                class_1291 statusEffect = statusEffectInstance.method_5579();
                Map map = statusEffect.method_5565();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        list2.add(new Pair((Object)((class_1320)entry.getKey()), (Object)((class_8630)entry.getValue()).method_52522(statusEffectInstance.method_5578())));
                    }
                }
                if (statusEffectInstance.method_5578() > 0) {
                    mutableText = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, class_2561.method_43471((String)("potion.potency." + statusEffectInstance.method_5578()))});
                }
                if (!statusEffectInstance.method_48557(20)) {
                    mutableText = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{mutableText, class_1292.method_5577((class_1293)statusEffectInstance, (float)1.0f, (float)(world == null ? 20.0f : world.method_54719().method_54748()))});
                }
                list.add((class_2561)mutableText.method_27692(statusEffect.method_18792().method_18793()));
            }
        }
        if (!list2.isEmpty()) {
            list.add(class_5244.field_39003);
            list.add((class_2561)class_2561.method_43471((String)"potion.whenDrank").method_27692(class_124.field_1064));
            for (Pair pair : list2) {
                class_1322 entityAttributeModifier = (class_1322)pair.getSecond();
                double d = entityAttributeModifier.method_6186();
                double e = entityAttributeModifier.method_6182() != class_1322.class_1323.field_6330 && entityAttributeModifier.method_6182() != class_1322.class_1323.field_6331 ? entityAttributeModifier.method_6186() : entityAttributeModifier.method_6186() * 100.0;
                if (d > 0.0) {
                    list.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + entityAttributeModifier.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(e), class_2561.method_43471((String)((class_1320)pair.getFirst()).method_26830())}).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(d < 0.0)) continue;
                list.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + entityAttributeModifier.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(e *= -1.0), class_2561.method_43471((String)((class_1320)pair.getFirst()).method_26830())}).method_27692(class_124.field_1061));
            }
        }
    }

    public void drawScreenFluidBar(TravelersBackpackHandledScreen screen, class_332 context) {
        RenderUtils.renderScreenTank(context, this.tank, screen.getX() + this.startX, screen.getY() + this.startY, 0.0, this.height, this.width);
    }

    public boolean inTank(TravelersBackpackHandledScreen screen, int mouseX, int mouseY) {
        return screen.getX() + this.startX <= mouseX && mouseX <= this.startX + this.width + screen.getX() && this.startY + screen.getY() <= mouseY && mouseY <= this.startY + this.height + screen.getY();
    }
}

