/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbossjaslow.horse_whistle.items;

import io.github.jbossjaslow.horse_whistle.HorseWhistle;
import io.github.jbossjaslow.horse_whistle.util.HotBarUtil;
import io.github.jbossjaslow.horse_whistle.util.NBTUtil;
import java.util.List;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4050;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class HorseWhistleItem
extends class_1792 {
    private static final String HORSE_ID_KEY = "horse_id";
    private static final String HORSE_NAME_KEY = "horse_name";
    private static final int ITEM_COOLDOWN = 20;

    public HorseWhistleItem(FabricItemSettings settings) {
        super((class_1792.class_1793)settings.maxDamage(HorseWhistle.CONFIG.durability()).rarity(class_1814.field_8903));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        super.method_7836(world, user, hand);
        class_1799 stack = user.method_5998(hand);
        if (user.method_37908().method_8608()) {
            return class_1271.method_22431((Object)stack);
        }
        if (user.method_18376() == class_4050.field_18081) {
            if (NBTUtil.hasNBTFor(stack, HORSE_ID_KEY)) {
                HotBarUtil.displayActionBarText("Removed attunement from " + NBTUtil.getNBTFrom(stack, HORSE_NAME_KEY), user, class_124.field_1060);
                NBTUtil.removeNBTFrom(stack, HORSE_ID_KEY);
                NBTUtil.removeNBTFrom(stack, HORSE_NAME_KEY);
                user.method_37908().method_8396(null, user.method_24515(), class_3417.field_14627, class_3419.field_15250, 0.5f, 0.5f);
                return class_1271.method_22428((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        }
        if (NBTUtil.hasNBTFor(stack, HORSE_ID_KEY)) {
            user.method_7357().method_7906((class_1792)this, 20);
            boolean[] isBroken = new boolean[]{false};
            stack.method_7956(1, (class_1309)user, p -> {
                p.method_20236(hand);
                isBroken[0] = true;
            });
            if (isBroken[0]) {
                return class_1271.method_22431((Object)stack);
            }
            String associatedHorseIdString = NBTUtil.getNBTFrom(stack, HORSE_ID_KEY);
            double radius = HorseWhistle.CONFIG.searchRadius();
            double xPos = user.method_23317();
            double yPos = user.method_23318();
            double zPos = user.method_23321();
            class_238 searchArea = new class_238(xPos - radius, yPos - radius, zPos - radius, xPos + radius, yPos + radius, zPos + radius);
            List horses = world.method_18023((class_5575)class_1299.field_6139, searchArea, class_1301.field_6157);
            for (class_1498 h : horses) {
                if (!h.method_5845().equals(associatedHorseIdString)) continue;
                this.teleportHorse(h, user, world);
                return class_1271.method_22428((Object)stack);
            }
            HotBarUtil.displayActionBarText("Could not find " + NBTUtil.getNBTFrom(stack, HORSE_NAME_KEY), user, class_124.field_1060);
        }
        return class_1271.method_22431((Object)stack);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        super.method_7847(stack, user, entity, hand);
        user.method_7357().method_7906((class_1792)this, 20);
        if (user.method_37908().method_8608()) {
            return class_1269.field_5814;
        }
        if (entity.method_5864() != class_1299.field_6139 || NBTUtil.hasNBTFor(stack, HORSE_ID_KEY)) {
            return class_1269.field_5811;
        }
        class_1498 horseEntity = (class_1498)entity;
        if (horseEntity.method_6727() && horseEntity.method_6139() == user.method_5667()) {
            user.method_37908().method_8396(null, user.method_24515(), class_3417.field_14627, class_3419.field_15250, 0.5f, 0.5f);
            NBTUtil.writeNBTTo(stack, HORSE_ID_KEY, horseEntity.method_5845());
            if (horseEntity.method_16914()) {
                NBTUtil.writeNBTTo(stack, HORSE_NAME_KEY, horseEntity.method_5797().getString());
            } else {
                NBTUtil.writeNBTTo(stack, HORSE_NAME_KEY, horseEntity.method_5477().getString());
            }
            HotBarUtil.displayActionBarText("Attuned whistle to " + NBTUtil.getNBTFrom(stack, HORSE_NAME_KEY), user, class_124.field_1060);
            return class_1269.method_29236((boolean)false);
        }
        return class_1269.field_5811;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        if (NBTUtil.hasNBTFor(stack, HORSE_NAME_KEY)) {
            String tooltipText = "Attuned to " + NBTUtil.getNBTFrom(stack, HORSE_NAME_KEY);
            tooltip.add((class_2561)class_2561.method_43471((String)tooltipText).method_27692(class_124.field_1080));
        }
    }

    public boolean method_7886(class_1799 stack) {
        return super.method_7886(stack) || NBTUtil.hasNBTFor(stack, HORSE_ID_KEY);
    }

    private void teleportHorse(class_1498 horse, class_1657 player, class_1937 world) {
        double xPos = player.method_23317();
        double yPos = player.method_23318();
        double zPos = player.method_23321();
        int randomX = horse.method_6051().method_43048(10) - 5;
        int randomZ = horse.method_6051().method_43048(10) - 5;
        horse.method_20620(xPos + (double)randomX, yPos, zPos + (double)randomZ);
        world.method_8396(null, player.method_24515(), class_3417.field_14890, class_3419.field_15250, 1.0f, 1.0f);
    }
}

