/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.util;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntUnaryOperator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import me.drex.villagerconfig.data.BehaviorTrade;
import me.drex.villagerconfig.data.TradeGroup;
import me.drex.villagerconfig.data.TradeTable;
import me.drex.villagerconfig.data.TradeTier;
import me.drex.villagerconfig.mixin.VillagerDataAccessor;
import me.drex.villagerconfig.util.loot.function.EnchantRandomlyLootFunction;
import me.drex.villagerconfig.util.loot.function.SetDyeFunction;
import me.drex.villagerconfig.util.loot.number.AddLootNumberProvider;
import me.drex.villagerconfig.util.loot.number.MultiplyLootNumberProvider;
import me.drex.villagerconfig.util.loot.number.ReferenceLootNumberProvider;
import net.minecraft.class_106;
import net.minecraft.class_111;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_152;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_2105;
import net.minecraft.class_215;
import net.minecraft.class_219;
import net.minecraft.class_2405;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3670;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3854;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5642;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_65;
import net.minecraft.class_6662;
import net.minecraft.class_7403;
import net.minecraft.class_77;
import net.minecraft.class_7784;
import net.minecraft.class_79;
import net.minecraft.class_7917;
import net.minecraft.class_7923;
import net.minecraft.class_85;
import net.minecraft.class_93;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class TradeProvider
implements class_2405 {
    private final class_7784.class_7489 pathResolver;
    private final boolean experimental;
    public static final class_2960 WANDERING_TRADER_ID = new class_2960("wanderingtrader");
    private static final IntUnaryOperator WANDERING_TRADER_COUNT = i -> switch (i) {
        case 1 -> 5;
        case 2 -> 1;
        default -> 0;
    };
    private static final IntUnaryOperator EXPERIMENTAL_WANDERING_TRADER_COUNT = i -> {
        if (i > class_3853.field_45129.size()) {
            return 0;
        }
        return (Integer)((Pair)class_3853.field_45129.get(i - 1)).getValue();
    };

    public TradeProvider(class_7784 output, boolean experimental) {
        this.pathResolver = output.method_45973(class_7784.class_7490.field_39367, "trades");
        this.experimental = experimental;
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 writer) {
        HashMap map = Maps.newHashMap();
        for (class_3852 villagerProfession : class_7923.field_41195) {
            Int2ObjectMap trades = (Int2ObjectMap)class_3853.field_17067.getOrDefault(villagerProfession, new Int2ObjectArrayMap());
            Int2ObjectMap experimentalTrades = (Int2ObjectMap)class_3853.field_45128.get(villagerProfession);
            if (this.experimental && experimentalTrades != null) {
                trades = experimentalTrades;
            }
            map.put(class_7923.field_41195.method_10221((Object)villagerProfession), new TradeData((Int2ObjectMap<class_3853.class_1652[]>)trades, OfferCountType.VILLAGER));
        }
        if (this.experimental) {
            Int2ObjectArrayMap experimentalTrades = new Int2ObjectArrayMap();
            List experimentalWanderingTraderTrades = class_3853.field_45129;
            for (int i = 0; i < experimentalWanderingTraderTrades.size(); ++i) {
                Pair pair = (Pair)experimentalWanderingTraderTrades.get(i);
                experimentalTrades.put(i + 1, (Object)((class_3853.class_1652[])pair.getLeft()));
            }
            map.put(WANDERING_TRADER_ID, new TradeData((Int2ObjectMap<class_3853.class_1652[]>)experimentalTrades, OfferCountType.EXPERIMENTAL_WANDERING_TRADER));
        } else {
            map.put(WANDERING_TRADER_ID, new TradeData((Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17724, OfferCountType.WANDERING_TRADER));
        }
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> {
            class_2960 identifier = (class_2960)entry.getKey();
            TradeData tradeData = (TradeData)entry.getValue();
            Path path = this.pathResolver.method_44107(identifier);
            int levels = tradeData.trades().size();
            TradeTier[] tiers = new TradeTier[levels];
            tradeData.trades().forEach((level, factoryArr) -> {
                TradeGroup tradeGroup = new TradeGroup((class_5658)class_44.method_32448((float)tradeData.offerCountType().getOfferCount((int)level)), Arrays.stream(factoryArr).map(this::convert).flatMap(Stream::of).map(BehaviorTrade.Builder::build).filter(Objects::nonNull).toList());
                tiers[level.intValue() - 1] = new TradeTier(VillagerDataAccessor.getNextLevelXpThresholds()[level - 1], List.of(tradeGroup));
            });
            TradeTable tradeTable = new TradeTable(List.of(tiers));
            return class_2405.method_53496((class_7403)writer, TradeTable.CODEC, (Object)tradeTable, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String method_10321() {
        return "Trades";
    }

    private BehaviorTrade.Builder[] convert(class_3853.class_1652 original) {
        if (original instanceof class_3853.class_4161) {
            class_3853.class_4161 factory = (class_3853.class_4161)original;
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)TradeProvider.lootTableItemStack(factory.field_45130), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18549)))).priceMultiplier(factory.field_18552).traderExperience(factory.field_18551).maxUses(factory.field_18550)};
        }
        if (original instanceof class_3853.class_4165) {
            class_3853.class_4165 factory = (class_3853.class_4165)original;
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18572))), (class_79.class_80<?>)TradeProvider.lootTableItemStack(factory.field_18571)).priceMultiplier(factory.field_18576).traderExperience(factory.field_18575).maxUses(factory.field_18574)};
        }
        if (original instanceof class_3853.class_4166) {
            class_3853.class_4166 factory = (class_3853.class_4166)original;
            class_85.class_86 suspciousStewBuilder = class_77.method_411((class_1935)class_1802.field_8766);
            for (class_7917.class_8751 effect : factory.field_45756) {
                suspciousStewBuilder.method_438((class_117.class_118)new class_152.class_153().method_640(effect.comp_1838(), (class_5658)class_44.method_32448((float)effect.comp_1839())));
            }
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687), (class_79.class_80<?>)suspciousStewBuilder).traderExperience(factory.field_18579)};
        }
        if (original instanceof class_3853.class_4164) {
            class_3853.class_4164 factory = (class_3853.class_4164)original;
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18565))), (class_79.class_80<?>)TradeProvider.lootTableItemStack(factory.field_18563), (class_79.class_80<?>)TradeProvider.lootTableItemStack(factory.field_18566)).priceMultiplier(factory.field_18570).traderExperience(factory.field_18569).maxUses(factory.field_18568)};
        }
        if (original instanceof class_3853.class_4163) {
            class_3853.class_4163 factory = (class_3853.class_4163)original;
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18559))).method_438((class_117.class_118)class_141.method_35540((class_5658)ReferenceLootNumberProvider.create("enchantLevel"), (boolean)true)), (class_79.class_80<?>)TradeProvider.lootTableItemStack(factory.field_18558).method_438((class_117.class_118)new class_106.class_107((class_5658)ReferenceLootNumberProvider.create("enchantLevel")))).priceMultiplier(factory.field_18562).traderExperience(factory.field_18561).maxUses(factory.field_18560).numberReference("enchantLevel", (class_5658)class_5662.method_32462((float)5.0f, (float)19.0f))};
        }
        if (original instanceof class_3853.class_4162) {
            class_3853.class_4162 factory = (class_3853.class_4162)original;
            class_79.class_80[] children = new class_79.class_80[class_7923.field_41194.method_10204()];
            int i = 0;
            for (class_3854 villagerType : class_7923.field_41194) {
                class_2487 root = new class_2487();
                class_2487 villagerData = new class_2487();
                villagerData.method_10582("type", class_7923.field_41194.method_10221((Object)villagerType).toString());
                root.method_10566("VillagerData", (class_2520)villagerData);
                children[i] = class_77.method_411((class_1935)((class_1935)factory.field_18553.get(villagerType))).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18554))).method_421(class_215.method_917((class_47.class_50)class_47.class_50.field_935, (class_2048.class_2049)class_2048.class_2049.method_8916().method_8915(new class_2105(root))));
                ++i;
            }
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_65.method_386((class_79.class_80[])children), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687)).priceMultiplier(0.05f).traderExperience(factory.field_18556).maxUses(factory.field_18555)};
        }
        if (original instanceof class_3853.class_4167) {
            class_3853.class_4167 factory = (class_3853.class_4167)original;
            List<class_1842> potions = class_7923.field_41179.method_10220().filter(potion -> !potion.method_8049().isEmpty() && class_1845.method_20361((class_1842)potion)).toList();
            class_79.class_80[] entries = new class_79.class_80[potions.size()];
            for (int i = 0; i < potions.size(); ++i) {
                class_1842 potion2 = potions.get(i);
                entries[i] = TradeProvider.lootTableItemStack(factory.field_18581).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18582))).method_438((class_117.class_118)class_6662.method_38927((class_1842)potion2));
            }
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18583))), (class_79.class_80<?>)class_77.method_411((class_1935)factory.field_18586).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18587))), (class_79.class_80<?>)class_93.method_35511((class_79.class_80[])entries)).priceMultiplier(factory.field_18588).traderExperience(factory.field_18585).maxUses(factory.field_18584)};
        }
        if (original instanceof class_3853.class_1648) {
            class_3853.class_1648 factory = (class_3853.class_1648)original;
            List<class_1887> defaultEnchantments = class_7923.field_41176.method_10220().filter(class_1887::method_25949).toList();
            EnchantRandomlyLootFunction.Builder enchantRandomlyFunction = new EnchantRandomlyLootFunction.Builder().minLevel(factory.field_45132).maxLevel(factory.field_45133).tradeEnchantments();
            if (!defaultEnchantments.equals(factory.field_45131)) {
                enchantRandomlyFunction.include((class_1887[])factory.field_45131.toArray(class_1887[]::new));
            }
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)MultiplyLootNumberProvider.create(AddLootNumberProvider.create(new class_5658[]{class_44.method_32448((float)2.0f), new class_5662((class_5658)class_44.method_32448((float)0.0f), (class_5658)AddLootNumberProvider.create(new class_5658[]{class_44.method_32448((float)5.0f), MultiplyLootNumberProvider.create(new class_5658[]{ReferenceLootNumberProvider.create("enchantmentLevel"), class_44.method_32448((float)10.0f)})})), MultiplyLootNumberProvider.create(new class_5658[]{class_44.method_32448((float)3.0f), ReferenceLootNumberProvider.create("enchantmentLevel")})}), ReferenceLootNumberProvider.create("treasureMultiplier")))), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8529), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8529).method_438((class_117.class_118)enchantRandomlyFunction)).traderExperience(factory.field_18557)};
        }
        if (original instanceof class_3853.class_1654) {
            class_3853.class_1654 factory = (class_3853.class_1654)original;
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18589))), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8251), (class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8895).method_438((class_117.class_118)new class_111.class_112().method_35521(100).method_499(factory.field_7473).method_502(factory.field_7474).method_500((byte)2).method_503(true)).method_438((class_117.class_118)class_3670.method_35549((class_2561)class_2561.method_43471((String)factory.field_37051)))).traderExperience(factory.field_18591).maxUses(factory.field_18590)};
        }
        if (original instanceof class_3853.class_4160) {
            class_3853.class_4160 factory = (class_3853.class_4160)original;
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((class_79.class_80<?>)class_77.method_411((class_1935)class_1802.field_8687).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)factory.field_18545))), (class_79.class_80<?>)class_77.method_411((class_1935)factory.field_18544).method_438((class_117.class_118)new SetDyeFunction.Builder(true)).method_438((class_117.class_118)new SetDyeFunction.Builder(true).method_524(class_219.method_932((float)0.3f))).method_438((class_117.class_118)new SetDyeFunction.Builder(true).method_524(class_219.method_932((float)0.2f)))).traderExperience(factory.field_18547).maxUses(factory.field_18546)};
        }
        if (original instanceof class_3853.class_8640) {
            class_3853.class_8640 factory = (class_3853.class_8640)original;
            ArrayList<BehaviorTrade.Builder> trades = new ArrayList<BehaviorTrade.Builder>(class_7923.field_41194.method_10204());
            for (Map.Entry entry : factory.comp_1962().entrySet()) {
                class_2487 root = new class_2487();
                class_2487 villagerData = new class_2487();
                villagerData.method_10582("type", class_7923.field_41194.method_10221((Object)((class_3854)entry.getKey())).toString());
                root.method_10566("VillagerData", (class_2520)villagerData);
                for (BehaviorTrade.Builder behaviorTrade : this.convert((class_3853.class_1652)entry.getValue())) {
                    behaviorTrade.when(class_215.method_917((class_47.class_50)class_47.class_50.field_935, (class_2048.class_2049)class_2048.class_2049.method_8916().method_8915(new class_2105(root))));
                    trades.add(behaviorTrade);
                }
            }
            return (BehaviorTrade.Builder[])trades.toArray(BehaviorTrade.Builder[]::new);
        }
        field_40831.warn("Unable to convert {}, generated json won't be complete!", original.getClass());
        return new BehaviorTrade.Builder[0];
    }

    private static class_85.class_86<?> lootTableItemStack(class_1799 itemStack) {
        class_85.class_86 builder = class_77.method_411((class_1935)itemStack.method_7909());
        if (itemStack.method_7947() != 1) {
            builder.method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)itemStack.method_7947())));
        }
        class_1890.method_8222((class_1799)itemStack).forEach((enchantment, level) -> builder.method_438((class_117.class_118)new class_5642.class_6158(true).method_35539(enchantment, (class_5658)class_44.method_32448((float)level.intValue()))));
        class_1842 potion = class_1844.method_8063((class_1799)itemStack);
        if (potion != class_1847.field_8984) {
            builder.method_438((class_117.class_118)class_6662.method_38927((class_1842)potion));
        }
        return builder;
    }

    public record TradeData(Int2ObjectMap<class_3853.class_1652[]> trades, OfferCountType offerCountType) {
    }

    public static enum OfferCountType {
        VILLAGER(i -> 2),
        WANDERING_TRADER(WANDERING_TRADER_COUNT),
        EXPERIMENTAL_WANDERING_TRADER(EXPERIMENTAL_WANDERING_TRADER_COUNT);

        private final IntUnaryOperator operator;

        private OfferCountType(IntUnaryOperator operator) {
            this.operator = operator;
        }

        public int getOfferCount(int level) {
            return this.operator.apply(level);
        }
    }
}

