/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import me.drex.villagerconfig.VillagerConfig;
import me.drex.villagerconfig.data.TradeTable;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TradeManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Logger LOGGER = VillagerConfig.LOGGER;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private Map<class_2960, TradeTable> trades = ImmutableMap.of();

    public TradeManager() {
        super(GSON, "trades");
    }

    @Nullable
    public TradeTable getTrade(class_2960 id) {
        return this.trades.get(id);
    }

    protected void apply(Map<class_2960, JsonElement> prepared, @NotNull class_3300 manager, @NotNull class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        prepared.forEach((identifier, jsonElement) -> {
            try {
                TradeTable table = (TradeTable)class_156.method_47526((DataResult)TradeTable.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement), JsonParseException::new);
                builder.put(identifier, (Object)table);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to load trade {}", identifier, (Object)exception);
            }
        });
        this.trades = builder.build();
        LOGGER.info("Loaded {} trades", (Object)this.trades.size());
    }

    public class_2960 getFabricId() {
        return new class_2960("villagerconfig", "trades");
    }
}

