/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.AnnotatedSettings;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.SettingNamingConvention;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.FiberException;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.drex.villagerconfig.VillagerConfig;
import me.drex.villagerconfig.config.Config;

public class ConfigManager {
    public static final Path CONFIG_PATH = VillagerConfig.DATA_PATH.resolve("villagerconfig.json5");
    private static final AnnotatedSettings ANNOTATED_SETTINGS = AnnotatedSettings.builder().useNamingConvention(SettingNamingConvention.SNAKE_CASE).build();
    public static final Config CONFIG = new Config();
    public static final ConfigTree TREE = ConfigTree.builder().applyFromPojo((Object)CONFIG, ANNOTATED_SETTINGS).build();
    private static final JanksonValueSerializer serializer = new JanksonValueSerializer(false);

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                ANNOTATED_SETTINGS.applyToNode(TREE, (Object)CONFIG);
                FiberSerialization.deserialize((ConfigTree)TREE, (InputStream)Files.newInputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)serializer);
            }
            catch (FiberException | IOException e) {
                VillagerConfig.LOGGER.error("Failed to load config file!", e);
            }
        } else {
            ConfigManager.saveModConfig();
        }
    }

    public static void saveModConfig() {
        try {
            ANNOTATED_SETTINGS.applyToNode(TREE, (Object)CONFIG);
            if (VillagerConfig.DATA_PATH.toFile().mkdirs()) {
                FiberSerialization.serialize((ConfigTree)TREE, (OutputStream)Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)serializer);
            }
        }
        catch (FiberException | IOException e) {
            VillagerConfig.LOGGER.error("Failed to save config file!", e);
        }
    }
}

